package com.elitescloud.boot.condition;

import com.elitescloud.boot.condition.support.OnRpcCondition;
import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * 是否启用RPC.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/28
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
@Inherited
@Conditional(OnRpcCondition.class)
public @interface ConditionalOnRpc {

    /**
     * 是否必须有OpenFeign
     *
     * @return
     */
    boolean requiredOpenFeign() default false;

    /**
     * 是否必须有dubbo
     *
     * @return
     */
    boolean requiredDubbo() default false;
}
