/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import com.elitescloud.cloudt.context.util.ResourceUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Map<String, List<String>> loadResourceProperties(@NotBlank String resourceName, @Nullable ClassLoader classLoader) {
        List<URL> resources = ResourceUtil.loadResource(resourceName, classLoader);
        if (resources.isEmpty()) {
            return Collections.emptyMap();
        }
        return PropertiesUtil.loadProperties(resources, true);
    }

    public static Map<String, List<String>> loadProperties(@NotEmpty List<URL> urls, boolean merge) {
        if (urls.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(128);
        for (URL url : urls) {
            Map<String, List<String>> properties = PropertiesUtil.loadProperties(url);
            if (merge) {
                for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
                    if (!result.containsKey(entry.getKey())) {
                        result.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    List valueList = (List)result.get(entry.getKey());
                    for (String value : entry.getValue()) {
                        if (valueList.contains(value)) continue;
                        valueList.add(value);
                    }
                }
                continue;
            }
            result.putAll(properties);
        }
        return result;
    }

    public static Map<String, List<String>> loadProperties(@NotNull URL url) {
        if (url == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(128);
        UrlResource resource = new UrlResource(url);
        Properties properties = null;
        try {
            properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u52a0\u8f7d\u914d\u7f6e" + url + "\u5f02\u5e38", e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] factoryImplementationNames;
            String factoryTypeName = ((String)entry.getKey()).trim();
            for (String factoryImplementationName : factoryImplementationNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()))) {
                result.computeIfAbsent(factoryTypeName, key -> new ArrayList()).add(factoryImplementationName.trim());
            }
        }
        return result;
    }
}

