package com.elitescloud.boot.common.annotation;

import com.elitescloud.boot.common.annotation.businessobject.BusinessParmObjectTypeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;

import java.lang.annotation.*;

/**
 * 业务对象操作.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/30
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessObjectOperation {
    String BUSINESS_OBJECT_NAME_DEFAULT = "@BusinessObject";

    /**
     * 操作类型
     *
     * @return 操作类型
     */
    OperationTypeEnum operationType();

    /**
     * 操作描述
     *
     * @return 操作描述
     */
    String operationDescription();

    /**
     * 操作详情
     *
     * @return 操作详情
     */
    String operationDetails() default "-";

    /**
     * 业务参数
     * <p>
     * 用于业务查询
     *
     * @return 业务参数
     */
    String businessParam() default "-";

    /**
     * 操作范围
     *
     * @return 操作范围
     */
    OperationScopeEnum operationScopeEnum() default OperationScopeEnum.PRIVATE_DOMAIN;

    /**
     * 操作状态
     *
     * @return 操作状态
     */
    OperationStateEnum operationStateEnum() default OperationStateEnum.RELEASED;

    /**
     * 是否记录日志
     *
     * @return 是否记录日志
     */
    boolean logEnabled() default false;

    /**
     * 是否记录入参
     *
     * @return 是否记录入参
     */
    boolean argsJsonEnabled() default false;

    /**
     * 是否记录出参
     *
     * @return 是否记录出参
     */
    boolean resultJsonEnabled() default false;

    /**
     * 业务对象
     * <p>
     * 业务操作的业务对象关联，如果不填写默认关联类上@BusinessObject内容
     *
     * @return 业务对象
     */
    String businessObjectType() default BUSINESS_OBJECT_NAME_DEFAULT;

    /**
     * 业务入参对象的取值名称
     * <p>
     * 当前版本不支持
     *
     * @return 取值名称
     */
    BusinessParmObjectTypeEnum businessParamObjectType() default BusinessParmObjectTypeEnum.ALL;

    /**
     * 业务参数取值key
     * <p>
     * 暂无用
     *
     * @return 业务参数取值key
     */
    String businessParamValueKey() default "";

    /**
     * 是否允许重复请求
     *
     * @return 默认允许重复请求
     */
    boolean allowRepeatRequest() default true;

    /**
     * 重复请求间隔时间
     * <p>
     * 单位毫秒，当值小于1时，使用系统的默认配置
     *
     * @return 间隔时间
     */
    int repeatIntervalMillis() default -1;
}
