package com.elitescloud.boot.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 树形entity基类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/29
 */
@Getter
@Setter
@MappedSuperclass
public abstract class BaseTreeModel extends BaseModel {
    private static final long serialVersionUID = -1736497525523946862L;
    /**
     * 默认父节点
     */
    public static final long DEFAULT_PARENT = -1;

    @Column
    @Comment(value = "上级节点ID", defaultValue = DEFAULT_PARENT + "")
    private Long pId;

    @Column
    @Comment(value = "根节点ID")
    private Long rootId;

    @Column
    @Comment(value = "左节点序号")
    private Integer lft;

    @Column
    @Comment(value = "右节点序号")
    private Integer rgt;

    @Column
    @Comment(value = "深度", defaultValue = "0")
    private Integer depth;

    @Column()
    @Comment(value = "顺序", defaultValue = "0")
    private Integer sortNo;
}
