package com.elitescloud.boot.support.bootstrap;

import com.elitescloud.boot.support.ConfigEncryptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.crypto.encrypt.TextEncryptor;

/**
 * 配置项加解密.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/1
 */
@Slf4j
public class CloudtTextEncryptor implements TextEncryptor {

    private final ConfigEncryptor encryptor;

    public CloudtTextEncryptor(String encryptorClazz) {
        log.info("启用自定义配置加解密：{}", encryptorClazz);
        try {
            this.encryptor = (ConfigEncryptor) Class.forName(encryptorClazz).getConstructor().newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException(encryptorClazz + "初始化失败，请确认至少有一个无参构造方法，且实现了接口" + ConfigEncryptor.class.getName(), e);
        }
    }

    @Override
    public String encrypt(String text) {
        return encryptor.encrypt(text);
    }

    @Override
    public String decrypt(String encryptedText) {
        return encryptor.decrypt(encryptedText);
    }
}
