package com.elitescloud.boot.common;

import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.base.SafeEnum;

import javax.validation.constraints.NotBlank;
import java.util.Objects;

/**
 * UDC常量类基类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/26
 */
public abstract class BaseUdc<T extends BaseUdc<T>> extends SafeEnum<T> {
    private static final long serialVersionUID = 3513316278376816427L;

    public BaseUdc() {
    }

    public BaseUdc(String value) {
        super(value);
    }

    public BaseUdc(String value, String description) {
        super(value, description);
    }

    /**
     * 应用编码，默认当前应用
     */
    @NotBlank
    public String getAppCode() {
        return CloudtAppHolder.getAppCode();
    }

    /**
     * UDC编码
     *
     * @return UDC编码
     */
    @NotBlank
    public abstract String getUdcCode();

    public final String toFullString() {
        return getAppCode() + ":" + getUdcCode() + ":" + getValue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(getAppCode(), getUdcCode(), getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseUdc) {
            BaseUdc<?> the = (BaseUdc<?>) obj;
            return Objects.equals(getAppCode(), the.getAppCode()) && Objects.equals(getUdcCode(), the.getUdcCode()) && Objects.equals(getValue(), the.getValue());
        }
        return false;
    }
}
