/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.util.ArrayUtil;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class ObjUtil
extends ObjectUtil {
    private ObjUtil() {
    }

    public static <T> void ifNotNull(T value, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T> void ifNull(T value, T defaultValue, @NotNull Consumer<T> consumer) {
        ObjUtil.ifNull(value, () -> defaultValue, consumer);
    }

    public static <T> void ifNull(T value, Supplier<T> defaultValue, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value == null) {
            consumer.accept(defaultValue.get());
        }
    }

    public static void ifNotBlank(String value, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (StringUtils.hasText((String)value)) {
            consumer.accept(value);
        }
    }

    public static void ifBlank(String value, String defaultValue, @NotNull Consumer<String> consumer) {
        ObjUtil.ifBlank(value, () -> defaultValue, consumer);
    }

    public static void ifBlank(String value, Supplier<String> defaultValue, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (!StringUtils.hasText((String)value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(Collection<T> value, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(Collection<T> value, Collection<T> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(Collection<T> value, Supplier<Collection<T>> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isEmpty(value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(T[] value, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isNotEmpty((Object[])value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(T[] value, T[] defaultValue, @NotNull Consumer<T[]> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(T[] value, Supplier<T[]> defaultValue, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])value)) {
            consumer.accept(defaultValue.get());
        }
    }
}

