package com.elitescloud.boot;

import com.elitescloud.boot.support.bootstrap.CloudtTextEncryptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.encrypt.TextEncryptor;

/**
 * 系统环境配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/1
 */
@EnableConfigurationProperties(CloudtBootstrapProperties.class)
@Order(Ordered.HIGHEST_PRECEDENCE)
public class CloudtBootstrapConfiguration {

    @Bean
    @ConditionalOnProperty(prefix = CloudtBootstrapProperties.CONFIG_PREFIX + ".config", name = "encryptor")
    public TextEncryptor cloudtTextEncryptor(CloudtBootstrapProperties properties) {
        return new CloudtTextEncryptor(properties.getConfig().getEncryptor());
    }
}
