package com.elitescloud.cloudt.system.constant;

import com.elitescloud.boot.base.SafeEnum;

/**
 * 租户类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/6
 */
public class TenantType extends SafeEnum<TenantType> {
    private static final long serialVersionUID = 3233285914612012307L;

    /**
     * 租户类型
     */
    public static final TenantType COMMON = new TenantType("COMMON", "普通租户");
    public static final TenantType OPERATION = new TenantType("OPERATION", "运营机构");

    public TenantType() {
    }

    public TenantType(String value) {
        super(value);
    }

    public TenantType(String value, String description) {
        super(value, description);
    }

    public static TenantType parse(String val) {
        return SafeEnum.valueOf(TenantType.class, val);
    }
}
