package com.elitescloud.boot.common.annotation;

import java.lang.annotation.*;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessParam {

    /**
     * 关联的业务对象
     *
     * @return 关联的业务对象类型
     */
    String relatedBusinessObject() default "";

    /**
     * 关联的业务对象的字段
     *
     * @return 字段名
     */
    String relatedField() default "";
}
