package com.elitescloud.cloudt.core.annotation;

import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;

import java.lang.annotation.*;

/**
 * 租户事务处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/7
 */
@Documented
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface TenantTransaction {

    /**
     * 隔离策略
     *
     * @return 是否
     */
    TenantIsolateType isolateType() default TenantIsolateType.TENANT;

    /**
     * 是否支持运营
     * <p>
     * 运营机构人员及admin访问时，将不使用隔离策略，可查询所有数据
     *
     * @return 是否
     */
    boolean supportOperation() default false;

    /**
     * 是否必须有当前租户
     * <p>
     * 如果true，如果当前上下文中租户为空，则抛出异常
     *
     * @return 默认否
     */
    boolean tenantRequired() default false;
}
