package com.elitescloud.boot.util;

import cn.hutool.core.text.CharSequenceUtil;

import javax.validation.constraints.NotNull;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * 字符串工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/24
 */
public class StrUtil extends cn.hutool.core.util.StrUtil {
    private StrUtil() {
    }

    /**
     * 控制时提供默认值
     *
     * @param value        字符串
     * @param defaultValue 默认值
     * @return 默认值
     */
    public static String blankToDefault(String value, Supplier<String> defaultValue) {
        if (CharSequenceUtil.isNotBlank(value)) {
            return value;
        }

        return defaultValue == null ? null : defaultValue.get();
    }

    /**
     * 如果值不为空时消费
     *
     * @param value    值
     * @param consumer 消费者
     */
    public static void ifNotBlank(String value, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (CharSequenceUtil.isNotBlank(value)) {
            consumer.accept(value);
        }
    }
}
