package com.elitescloud.boot.common.annotation;

import java.lang.annotation.*;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessParam {

    /**
     * 关联的业务对象
     *
     * @return 关联的业务对象类型
     */
    String relatedBusinessObject() default "";

    /**
     * 关联的业务对象的字段
     * <p>
     * 默认是id
     *
     * @return 字段名
     */
    String relatedField() default "id";

    /**
     * 限制的取值集合
     * <p>
     * 如UDC的过滤：<pre>{@code
     *         @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_PLATFORM_UDC, relatedField = "udcValueCode", values = {Application.NAME, "employeeType"})
     *         private String employeeType;
     *  }</pre>
     *
     * @return 值列表
     */
    String[] values() default {};

    /**
     * 是否用于数据权限控制
     *
     * @return 是否
     */
    boolean dataPermissionEnabled() default true;

    /**
     * 是否用于字段权限控制
     *
     * @return 是否
     */
    boolean fieldPermissionEnabled() default true;
}
