/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class ObjUtil
extends ObjectUtil {
    private ObjUtil() {
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ApiResult) {
            return ObjUtil.isEmpty(((ApiResult)obj).getData());
        }
        if (obj instanceof PagingVO) {
            return ((PagingVO)obj).isEmpty();
        }
        return ObjectUtil.isEmpty((Object)obj);
    }

    public static <T> void ifNotNull(T value, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T> void ifNull(T value, T defaultValue, @NotNull Consumer<T> consumer) {
        ObjUtil.ifNull(value, () -> defaultValue, consumer);
    }

    public static <T> void ifNull(T value, Supplier<T> defaultValue, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value == null) {
            consumer.accept(defaultValue.get());
        }
    }

    public static void ifNotBlank(String value, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (StringUtils.hasText((String)value)) {
            consumer.accept(value);
        }
    }

    public static void ifBlank(String value, String defaultValue, @NotNull Consumer<String> consumer) {
        ObjUtil.ifBlank(value, () -> defaultValue, consumer);
    }

    public static void ifBlank(String value, Supplier<String> defaultValue, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (!StringUtils.hasText((String)value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(Collection<T> value, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(Collection<T> value, Collection<T> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(Collection<T> value, Supplier<Collection<T>> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isEmpty(value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(T[] value, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isNotEmpty((Object[])value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(T[] value, T[] defaultValue, @NotNull Consumer<T[]> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(T[] value, Supplier<T[]> defaultValue, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void unwrap(Object wrappedObj, @NotNull Consumer<T> objConsumer) {
        Class<?> clazz = null;
        if (wrappedObj == null || ClassUtil.isSimpleValueType(clazz = wrappedObj.getClass())) {
            return;
        }
        if (wrappedObj instanceof ApiResult) {
            ObjUtil.unwrap(((ApiResult)wrappedObj).getData(), objConsumer);
            return;
        }
        if (wrappedObj instanceof PagingVO) {
            for (Object record : ((PagingVO)wrappedObj).getRecords()) {
                ObjUtil.unwrap(record, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Map) {
            for (Object value : ((Map)wrappedObj).values()) {
                ObjUtil.unwrap(value, objConsumer);
            }
            return;
        }
        if (clazz.isArray()) {
            for (Object o2 : (Object[])wrappedObj) {
                ObjUtil.unwrap(o2, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Iterable) {
            for (Object o3 : (Iterable)wrappedObj) {
                ObjUtil.unwrap(o3, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Optional) {
            ((Optional)wrappedObj).ifPresent(o -> ObjUtil.unwrap(o, objConsumer));
            return;
        }
        if (wrappedObj instanceof CloudtOptional) {
            ((CloudtOptional)wrappedObj).ifPresent(o -> ObjUtil.unwrap(o, objConsumer));
            return;
        }
        objConsumer.accept(wrappedObj);
    }
}

