package com.elitescloud.boot.common.annotation;

import com.elitescloud.boot.common.translate.TranslatorCustomizer;

import java.lang.annotation.*;

/**
 * 自动化数据翻译.
 * <p>
 * 可自动对所有实现了 {@link TranslatorCustomizer}接口且注册为Spring Bean对象的进行自动调用进行翻译业务数据
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/8
 */
@Documented
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface GlobalTranslate {

    /**
     * 是否递归深入翻译
     * <p>
     * 默认只翻译第一层数据，色孩子为true后会对其中的属性进行递归判断，如果属性不是基本类型，则会继续进行拆包翻译，支持自动拆包{@link com.elitescloud.cloudt.common.base.ApiResult}、{@link com.elitescloud.cloudt.common.base.PagingVO}及集合
     *
     * @return 是否递归
     */
    boolean recursive() default false;

    /**
     * 排除掉的翻译器编码
     *
     * @return 翻译器编码
     */
    String[] excludeTranslators() default {};
}
