package com.elitescloud.boot.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务对象操作信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
public class SysBusinessOperationDTO implements Serializable {
    private static final long serialVersionUID = 4852768677101606464L;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 业务对象编码
     */
    private String businessObjectCode;

    /**
     * 业务操作编码
     */
    private String operationCode;

    /**
     * 操作名称
     */
    private String operationDescription;

    /**
     * 关联的操作编码
     */
    private String permissionRef;

    /**
     * 是否启用权限
     */
    private Boolean permissionEnabled;

    /**
     * 是否自动过滤字段权限
     */
    private Boolean fieldPermissionAutoFilter;

    /**
     * URL
     */
    private String apiUrl;

    /**
     * 请求方法
     */
    private String apiMethod;
}
