package com.elitescloud.boot.support;

import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 自定义拦截器父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/27
 */
public interface CloudtInterceptor extends AsyncHandlerInterceptor {

    /**
     * 执行前的处理
     * <p>
     * 在 {@link #preHandle(HttpServletRequest, HttpServletResponse, Object)} 处理之后，在 {@link #postHandle(HttpServletRequest, HttpServletResponse, Object, ModelAndView)} 处理之前
     *
     * @param handler    处理器
     * @param parameters 参数
     * @return 参数
     */
    default Object[] beforeHandle(Object handler, Object[] parameters) {
        return parameters;
    }

    /**
     * 默认顺序
     *
     * @return
     */
    default int order() {
        return 0;
    }

    /**
     * 匹配拦截的路径
     *
     * @return 默认拦截所有
     */
    default String pathPatterns() {
        return "/**";
    }

    /**
     * 静态资源
     * <p>
     * 可过滤掉的
     *
     * @return
     */
    static Set<String> staticResourcePatter() {
        Set<String> excludePath = new HashSet<>();

        // swagger
        excludePath.add("/doc.html");
        excludePath.add("/doc/index.html");
        excludePath.add("/webjars/**");
        excludePath.add("/swagger-resources");
        excludePath.add("/*/api-docs");

        // 健康检查
        excludePath.add("/actuator/**");

        return excludePath;
    }

    /**
     * 转换至RequestMatcher
     *
     * @param uris
     * @return
     */
    static List<PathPattern> convert2RequestMatcher(Collection<String> uris) {
        return uris.stream()
                .map(PathPatternParser.defaultInstance::parse)
                .collect(Collectors.toList());
    }
}
