package com.elitescloud.boot.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;

/**
 * 代理工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/18
 */
@Slf4j
public class ProxyUtil {
    private ProxyUtil() {
    }

    /**
     * 是否被spring代理为bean
     *
     * @param bean 对象
     * @return 是否
     */
    public static boolean isProxyBySpring(Object bean) {
        return bean instanceof Advised;
    }

    /**
     * 获取代理的对象
     *
     * @param bean 对象
     * @return 原对象
     */
    public static Object getTargetBeanForSpring(Object bean) {
        if (bean instanceof Advised) {
            try {
                return ((Advised) bean).getTargetSource().getTarget();
            } catch (Exception e) {
                log.error("获取代理对象异常：", e);
            }
        }
        return null;
    }

    /**
     * 获取目标class
     * <p>
     * 如果bean是spring代理的对象，则返回其真实对象
     *
     * @param bean 对象
     * @return 对象class
     */
    public static Class<?> getTargetClass(Object bean) {
        return AopProxyUtils.ultimateTargetClass(bean);
    }
}
