/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot;

import com.elitescloud.boot.CloudtContextProperties;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.context.properties.DataFormatterProperties;
import com.elitescloud.boot.provider.DataFormatterProvider;
import com.elitescloud.boot.provider.impl.DefaultDataFormatterProvider;
import com.elitescloud.boot.support.app.CloudtAppConfig;
import com.elitescloud.boot.support.serializer.BigDecimalSerializer;
import com.elitescloud.boot.support.transfer.ExcutorContextTransfer;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.boot.util.CloudtBootUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.math.BigDecimal;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.support.TaskUtils;

@Import(value={JacksonConfiguration.class, AsyncConfiguration.class, CloudtAppConfig.class})
@EnableConfigurationProperties(value={CloudtContextProperties.class, DataFormatterProperties.class})
@Order(value=-2147483648)
class CloudtContextAutoConfiguration
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(CloudtContextAutoConfiguration.class);
    @Autowired
    private SimpleApplicationEventMulticaster applicationEventMulticaster;

    CloudtContextAutoConfiguration() {
    }

    public void afterPropertiesSet() throws Exception {
        this.applicationEventMulticaster.setErrorHandler(TaskUtils.LOG_AND_SUPPRESS_ERROR_HANDLER);
    }

    @Bean
    public CloudtActuatorInfo cloudtActuatorInfo() {
        return new CloudtActuatorInfo();
    }

    @Bean
    public ContextTransfer<ExecutorContextHolder.ExecutorContext> excutorContextTransfer() {
        return new ExcutorContextTransfer();
    }

    static class CloudtActuatorInfo
    implements InfoContributor {
        CloudtActuatorInfo() {
        }

        public void contribute(Info.Builder builder) {
            builder.withDetail("Cloudt-Boot-Version", (Object)CloudtBootUtil.getVersion());
        }
    }

    @EnableAsync
    static class AsyncConfiguration
    implements AsyncConfigurer {
        private static final Logger log = LogManager.getLogger(AsyncConfiguration.class);
        private final TaskExecutor taskExecutor;

        public AsyncConfiguration(TaskExecutor taskExecutor) {
            this.taskExecutor = taskExecutor;
        }

        public Executor getAsyncExecutor() {
            return this.taskExecutor;
        }

        public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
            return (ex, method, params) -> log.error("\u5f02\u6b65\u7ebf\u7a0b\u3010" + method.getDeclaringClass().getName() + "." + method.getName() + "\u3011\u6267\u884c\u5f02\u5e38\uff1a", ex);
        }
    }

    static class JacksonConfiguration {
        JacksonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataFormatterProvider dataFormatterProvider(DataFormatterProperties properties) {
            return new DefaultDataFormatterProvider(properties);
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
            return ObjectMapperFactory::builderInstance;
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizerBigDecimal(DataFormatterProvider dataFormatterProvider) {
            return builder -> builder.serializerByType(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer(dataFormatterProvider));
        }

        @Bean
        public LocalDateTimeSerializer localDateTimeSerializer() {
            return new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME);
        }

        @Bean
        public LocalDateTimeDeserializer localDateTimeDeserializer() {
            return new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME);
        }
    }
}

