package com.elitescloud.cloudt.system.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * UDC.
 *
 * @author Kaiser（wang shao）
 * 2022/10/24
 */
@Data
public class SysUdcDTO implements Serializable {
    private static final long serialVersionUID = -9217431364120643981L;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * UDC编码
     */
    private String udcCode;

    /**
     * UDC名称
     */
    private String udcName;

    /**
     * UDC描述
     */
    private String udcDescribe;

    /**
     * 上级UDC编码
     */
    private String parentUdcCode;

    /**
     * 值列表
     */
    private List<UdcValue> valueList;

    @Data
    public static class UdcValue implements Serializable {
        private static final long serialVersionUID = 1383473803571219626L;

        /**
         * UDC值编码
         */
        private String udcValueCode;

        /**
         * UDC值名称
         */
        private String udcValueName;

        /**
         * 排序
         */
        private Integer udcOrder;

        /**
         * 值描述
         */
        private String udcValueDescribe;

        /**
         * 是否启用
         */
        private Boolean enabled;

        /**
         * 上级UDC值编码
         */
        private String parentUdcValueCode;
    }
}
