/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JSONUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JSONUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();

    public static String toJsonString(Object obj) {
        return JSONUtil.toJsonString(obj, false, null);
    }

    public static String toJsonString(Object obj, boolean safely) {
        return JSONUtil.toJsonString(obj, safely, null);
    }

    public static String toJsonString(Object obj, boolean safely, Supplier<String> errorMsg) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isPrimitive()) {
            return obj.toString();
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            String eMsg;
            String string = eMsg = errorMsg == null ? "\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u5f02\u5e38" : errorMsg.get();
            if (safely) {
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error(eMsg, (Throwable)e);
            return null;
        }
    }

    public static byte[] toJsonBytes(Object obj) {
        return JSONUtil.toJsonBytes(obj, false, null);
    }

    public static byte[] toJsonBytes(Object obj, boolean safely) {
        return JSONUtil.toJsonBytes(obj, safely, null);
    }

    public static byte[] toJsonBytes(Object obj, boolean safely, Supplier<String> errorMsg) {
        if (obj == null) {
            return new byte[0];
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            String eMsg;
            String string = eMsg = errorMsg == null ? "\u8f6c\u6362byte\u5f02\u5e38" : errorMsg.get();
            if (safely) {
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error(eMsg, (Throwable)e);
            return null;
        }
    }

    public static <T> T json2Obj(String json, Class<T> clazz) {
        return JSONUtil.json2Obj(json, clazz, false, null);
    }

    public static <T> T json2Obj(String json, Class<T> clazz, boolean safely) {
        return JSONUtil.json2Obj(json, clazz, safely, null);
    }

    public static <T> T json2Obj(String json, Class<T> clazz, boolean safely, Supplier<String> errorMsg) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            if (safely) {
                String eMsg = errorMsg == null ? "JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("json\u5b57\u7b26\u4e32\u3010{}\u3011\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T jsonBytes2Obj(byte[] json, Class<T> clazz) {
        return JSONUtil.jsonBytes2Obj(json, clazz, false, null);
    }

    public static <T> T jsonBytes2Obj(byte[] json, Class<T> clazz, boolean safely) {
        return JSONUtil.jsonBytes2Obj(json, clazz, safely, null);
    }

    public static <T> T jsonBytes2Obj(byte[] json, Class<T> clazz, boolean safely, Supplier<String> errorMsg) {
        if (ArrayUtil.isEmpty((byte[])json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            if (safely) {
                String eMsg = errorMsg == null ? "byte\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("byte\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static <T> T json2Obj(String json) {
        return JSONUtil.json2Obj(json, false);
    }

    public static <T> T json2Obj(String json, TypeReference<T> typeReference) {
        return JSONUtil.json2Obj(json, typeReference, false, null);
    }

    public static <T> T json2Obj(String json, boolean safely) {
        return JSONUtil.json2Obj(json, safely, null);
    }

    public static <T> T json2Obj(String json, boolean safely, Supplier<String> errorMsg) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, new TypeReference<T>(){});
        }
        catch (JsonProcessingException e) {
            if (safely) {
                String eMsg = errorMsg == null ? "JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("json\u5b57\u7b26\u4e32\u3010{}\u3011\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T json2Obj(String json, TypeReference<T> typeReference, boolean safely, Supplier<String> errorMsg) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        if (typeReference == null) {
            return JSONUtil.json2Obj(json, safely, errorMsg);
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (JsonProcessingException e) {
            if (safely) {
                String eMsg = errorMsg == null ? "JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("json\u5b57\u7b26\u4e32\u3010{}\u3011\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T jsonBytes2Obj(byte[] json) {
        return JSONUtil.jsonBytes2Obj(json, false);
    }

    public static <T> T jsonBytes2Obj(byte[] json, TypeReference<T> typeReference) {
        return JSONUtil.jsonBytes2Obj(json, typeReference, false, null);
    }

    public static <T> T jsonBytes2Obj(byte[] json, boolean safely) {
        return JSONUtil.jsonBytes2Obj(json, safely, null);
    }

    public static <T> T jsonBytes2Obj(byte[] json, boolean safely, Supplier<String> errorMsg) {
        if (ArrayUtil.isEmpty((byte[])json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, new TypeReference<T>(){});
        }
        catch (Exception e) {
            if (safely) {
                String eMsg = errorMsg == null ? "JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("json\u5b57\u7b26\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static <T> T jsonBytes2Obj(byte[] json, TypeReference<T> typeReference, boolean safely, Supplier<String> errorMsg) {
        if (ArrayUtil.isEmpty((byte[])json)) {
            return null;
        }
        if (typeReference == null) {
            return JSONUtil.jsonBytes2Obj(json, safely, errorMsg);
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            if (safely) {
                String eMsg = errorMsg == null ? "byte\u8f6c\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.error("byte\u8f6c\u5bf9\u8c61\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static <T> T convertObj(Object object, @NotNull Class<T> clazz) {
        return JSONUtil.convertObj(object, clazz, false, null);
    }

    public static <T> T convertObj(Object object, @NotNull Class<T> clazz, boolean safely) {
        return JSONUtil.convertObj(object, clazz, safely, null);
    }

    public static <T> T convertObj(Object object, @NotNull Class<T> clazz, boolean safely, Supplier<String> errorMsg) {
        if (object == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.convertValue(object, clazz);
        }
        catch (Exception e) {
            if (safely) {
                String eMsg = errorMsg == null ? "\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.warn("\u8f6c\u5bf9\u8c61\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T convertObj(Object object, @NotNull TypeReference<T> typeReference) {
        return JSONUtil.convertObj(object, typeReference, false, null);
    }

    public static <T> T convertObj(Object object, @NotNull TypeReference<T> typeReference, boolean safely) {
        return JSONUtil.convertObj(object, typeReference, safely, null);
    }

    public static <T> T convertObj(Object object, @NotNull TypeReference<T> typeReference, boolean safely, Supplier<String> errorMsg) {
        if (object == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.convertValue(object, typeReference);
        }
        catch (Exception e) {
            if (safely) {
                String eMsg = errorMsg == null ? "\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38" : errorMsg.get();
                throw new IllegalArgumentException(eMsg, e);
            }
            LOG.warn("\u8f6c\u5bf9\u8c61\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }
}

