package com.elitescloud.boot.context;

/**
 * 租户组织上下文.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/4
 */
public final class TenantOrgContext {
    private TenantOrgContext() {
    }

    /**
     * 是否所有组织（不使用租户组织过滤）
     */
    private static final ThreadLocal<Boolean> USE_TENANT_ORG = new ThreadLocal<>();
    /**
     * 指定的租户组织
     */
    private static final ThreadLocal<Long> TENANT_ORG_ID = new ThreadLocal<>();

    /**
     * 是否使用租户组织
     *
     * @return 是否
     */
    public static Boolean isUseTenantOrg() {
        return USE_TENANT_ORG.get();
    }

    /**
     * 设置是否使用租户组织
     *
     * @param use 是否
     */
    public static void setUseTenantOrg(boolean use) {
        USE_TENANT_ORG.set(use);
    }

    /**
     * 清楚是否使用租户组织的上下文信息
     */
    public static void clearUseTenantOrg() {
        USE_TENANT_ORG.remove();
    }

    /**
     * 获取设置的租户组织
     *
     * @return 是否
     */
    public static Long getTenantOrg() {
        return TENANT_ORG_ID.get();
    }

    /**
     * 设置使用的租户组织
     *
     * @param tenantOrgId 租户组织ID
     */
    public static void setTenantOrgId(Long tenantOrgId) {
        TENANT_ORG_ID.set(tenantOrgId);
    }

    /**
     * 清楚使用的租户组织的上下文信息
     */
    public static void cleaTenantOrgId() {
        TENANT_ORG_ID.remove();
    }
}
