package com.elitescloud.boot.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
public class SysBusinessParamDTO implements Serializable {
    private static final long serialVersionUID = 1978030364285045114L;

    /**
     * 业务对象编码
     */
    private String businessObjectCode;

    /**
     * 业务操作编码
     */
    private String businessOperationCode;

    /**
     * 是否为entity类的字段
     */
    private Boolean entityField;

    /**
     * entity类的名称
     */
    private Boolean entityClassName;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段描述
     */
    private String fieldDescription;

    /**
     * 字段类型
     */
    private String fieldJavaType;

    /**
     * 是否单值
     */
    private Boolean single;

    /**
     * 关联业务对象标识
     */
    private String relatedBusinessObject;

    /**
     * 关联业务对象字段
     */
    private String relatedField;

    /**
     * 允许值
     */
    private List<String> values;

    /**
     * 是否应于数据权限过滤
     */
    private Boolean dataPermissionEnabled;

    /**
     * 是否为基础字段
     */
    private Boolean fieldPermissionEnabled;
}
