/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.springframework.util.ClassUtils;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static List<URL> loadResource(@NotBlank String name, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = (ClassLoader)ObjectUtil.defaultIfNull((Object)ClassUtils.getDefaultClassLoader(), (Object)ResourceUtil.class.getClassLoader());
        }
        ArrayList<URL> urlList = new ArrayList<URL>(128);
        try {
            Enumeration<URL> urls = classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                urlList.add(url);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u52a0\u8f7d\u8d44\u6e90" + name + "\u5f02\u5e38", e);
        }
        return urlList;
    }
}

