package com.elitescloud.boot.context.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.math.RoundingMode;

/**
 * 数据格式配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
@ConfigurationProperties(prefix = DataFormatterProperties.CONFIG_PREFIX)
public class DataFormatterProperties {
    public static final String CONFIG_PREFIX = "elitesland.data-formatter";

    /**
     * BigDecimal格式化配置
     */
    @NestedConfigurationProperty
    private BigDecimalFormatter bigDecimal = new BigDecimalFormatter();

    public BigDecimalFormatter getBigDecimal() {
        return bigDecimal;
    }

    public void setBigDecimal(BigDecimalFormatter bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    public static class BigDecimalFormatter {

        /**
         * 是否启用
         */
        private Boolean enabled = false;

        /**
         * 金额
         */
        @NestedConfigurationProperty
        private BigDecimalCfg amount = new BigDecimalCfg();

        /**
         * 价格
         */
        @NestedConfigurationProperty
        private BigDecimalCfg price = new BigDecimalCfg();

        /**
         * 数量
         */
        @NestedConfigurationProperty
        private BigDecimalCfg quantity = new BigDecimalCfg();

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public BigDecimalCfg getAmount() {
            return amount;
        }

        public void setAmount(BigDecimalCfg amount) {
            this.amount = amount;
        }

        public BigDecimalCfg getPrice() {
            return price;
        }

        public void setPrice(BigDecimalCfg price) {
            this.price = price;
        }

        public BigDecimalCfg getQuantity() {
            return quantity;
        }

        public void setQuantity(BigDecimalCfg quantity) {
            this.quantity = quantity;
        }
    }

    public static class BigDecimalCfg {
        /**
         * 默认小数位数
         */
        private int defaultScale = 4;

        /**
         * 取舍模式
         * <p>
         * 取值参考：{@link RoundingMode}
         */
        private int defaultRoundingModeValue = 4;

        /**
         * 取舍模式
         * <p>
         * 与{@link #defaultRoundingModeValue} 配置其一即可，该值优先级最高
         */
        private RoundingMode defaultRoundingMode;

        public int getDefaultScale() {
            return defaultScale;
        }

        public void setDefaultScale(int defaultScale) {
            this.defaultScale = defaultScale;
        }

        public int getDefaultRoundingModeValue() {
            return defaultRoundingModeValue;
        }

        public void setDefaultRoundingModeValue(int defaultRoundingModeValue) {
            this.defaultRoundingModeValue = defaultRoundingModeValue;
        }

        public RoundingMode getDefaultRoundingMode() {
            return defaultRoundingMode;
        }

        public void setDefaultRoundingMode(RoundingMode defaultRoundingMode) {
            this.defaultRoundingMode = defaultRoundingMode;
        }
    }
}
