package com.elitescloud.boot.util;

import cn.hutool.core.lang.Assert;
import org.springframework.util.ClassUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/18
 */
public class ClassUtil extends cn.hutool.core.util.ClassUtil {

    /**
     * 获取bean的原始类
     *
     * @param bean bean对象
     * @return class
     */
    public static Class<?> getTargetClass(@NotNull Object bean) {
        return ProxyUtil.getTargetClass(bean);
    }

    /**
     * 获取泛型接口的泛型参数
     *
     * @param obj              对象或class
     * @param genericInterface 泛型接口
     * @return 参数列表
     */
    public static Type[] getTypeArguments(@NotNull Object obj, @NotNull Class<?> genericInterface) {
        Class<?> clazz = obj instanceof Class ? (Class<?>) obj : getTargetClass(obj);
        Assert.notNull(genericInterface, "泛型接口为空");

        while (true) {
            if (clazz == null || !genericInterface.isAssignableFrom(clazz)) {
                break;
            }
            var genericInterfaces = clazz.getGenericInterfaces();
            // 父类
            clazz = clazz.getSuperclass();
            if (ArrayUtil.isEmpty(genericInterfaces)) {
                continue;
            }

            Class<?> tempClazz = null;
            // 获取实现的接口
            for (Type inter : genericInterfaces) {
                var paramType = (ParameterizedType) inter;
                if (paramType.getRawType() == genericInterface) {
                    return paramType.getActualTypeArguments();
                }
                if (genericInterface.isAssignableFrom((Class<?>) paramType.getRawType()) && tempClazz == null) {
                    tempClazz = (Class<?>) paramType.getRawType();
                }
            }
            // 优先取父类
            if (clazz != null && !genericInterface.isAssignableFrom(clazz)) {
                clazz = tempClazz;
            }
        }
        return null;
    }

    /**
     * 是否存在类
     *
     * @param className 类名
     * @return 是否存在
     */
    public static boolean isPresent(@NotBlank String className) {
        return isPresent(className, null);
    }

    /**
     * 是否存在类
     *
     * @param className 类名
     * @return 是否存在
     */
    public static boolean isPresent(@NotBlank String className, ClassLoader classLoader) {
//        return ClassLoaderUtil.isPresent(className);

        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            Class.forName(className, false, classLoader);
            return true;
        } catch (Throwable ex) {
            return false;
        }
    }
}
