package com.elitescloud.cloudt.system.vo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Michael Li
 */
@Data
@Accessors(chain = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserDTO implements Serializable {

    private static final long serialVersionUID = -307368107814607072L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 公司编码
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 用户姓氏
     */
    private String lastName;

    /**
     * 用户名称
     */
    private String firstName;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 统一身份认证用户ID
     */
    private Long casUserId;

    /**
     * 微信openid
     */
    private String wxOpenid;

    /**
     * 账号来源
     * {@link UserSourceType}
     */
    private String sourceType;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否需要重置密码
     */
    private Boolean needReset;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 密码过期时间
     */
    private LocalDateTime pwdExpiredTime;

    /**
     * 账号是否已锁定
     */
    private Boolean locked;

    /**
     * 用户类型
     * @deprecated 请使用 {@link #userTypeList}
     */
    @Deprecated
    private String userType;

    /**
     * 角色编码
     */
    private Set<String> roleCodes = Collections.emptySet();

    /**
     * 角色信息
     */
    private List<IdCodeNameParam> roles = Collections.emptyList();

    /**
     * 用户头像地址
     */
    private String avatarUrl;

    /**
     * 用户头像的文件编码
     */
    private String avatarCode;

    /**
     * 用户的终端
     */
    @Deprecated
    private List<Terminal> terminals = Collections.emptyList();

    /**
     * 用户所有的租户
     */
    private List<SysTenantDTO> sysTenantDTOList = Collections.emptyList();

    /**
     * 用户当前的租户
     */
    private SysTenantDTO sysTenantVO;

    /**
     * 所在组织的列表
     */
    private List<SysOrgBasicDTO> orgList;

    /**
     * 当前组织
     */
    private SysOrgBasicDTO org;

    /**
     * 所属租户组织
     */
    private SysOrgBasicDTO tenantOrg;

    /**
     * 当前岗位
     */
    private IdCodeNameParam position;

    /**
     * 租户组织管理员ID
     */
    private Long tenantOrgAdminId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 账号类型
     */
    private List<SysUserType> userTypeList;

    /**
     * 下属
     */
    private List<SysUnderlingDTO> underlingList;

    /**
     * 扩展信息
     */
    private Object extend;

    public Long getTenantId() {
        if (sysTenantVO != null) {
            return sysTenantVO.getId();
        }
        return tenantId;
    }

    /**
     * 获取租户组织ID
     *
     * @return 租户组织ID
     */
    public Long getTenantOrgId() {
        if (tenantOrg == null) {
            return null;
        }
        return tenantOrg.getId();
    }

    /**
     * 获取姓名
     *
     * @return 姓名
     */
    public String getPrettyName() {
        StringBuilder result = new StringBuilder();
        if (getLastName() != null) {
            result.append(getLastName());
        }
        if (getFirstName() != null) {
            result.append(getFirstName());
        }

        return result.toString();
    }

    /**
     * 密码剩余有效天数
     *
     * @return 天数
     */
    public Integer getRemainingDaysOfPwd() {
        if (pwdExpiredTime == null) {
            return null;
        }

        return Math.toIntExact(Duration.between(LocalDateTime.now(), pwdExpiredTime).toDays());
    }

    public Set<Long> getRoleIds() {
        if (CollectionUtils.isEmpty(roles)) {
            return Collections.emptySet();
        }
        Set<Long> roleIds = new HashSet<>(roles.size());
        for (IdCodeNameParam role : roles) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }
}
