/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.util.AspectUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;

public class CloudtSpelExpressionEvaluator
extends CachedExpressionEvaluator {
    private static final CloudtSpelExpressionEvaluator INSTANCE = new CloudtSpelExpressionEvaluator();
    private final Map<AnnotatedElementKey, CloudtSpelMetadata> metadataCache = new ConcurrentHashMap<AnnotatedElementKey, CloudtSpelMetadata>(256);
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> keyCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(256);

    private CloudtSpelExpressionEvaluator() {
    }

    public static CloudtSpelExpressionEvaluator getInstance() {
        return INSTANCE;
    }

    public EvaluationContext createEvaluationContext(@NotNull Object target, @NotNull Method method, Object[] args) {
        Class<?> targetClass = this.getTargetClass(target);
        CloudtSpelMetadata metadata = this.getCloudtSpelMetadata(method, targetClass);
        CloudtSpelRootObject rootObject = new CloudtSpelRootObject(method, args, target, targetClass);
        return new CloudtSpelEvaluationContext(rootObject, metadata.getMethod(), args, target, metadata.getTargetClass(), metadata.getTargetMethod(), metadata.getMethodKey(), this.getParameterNameDiscoverer());
    }

    public Object parseExpression(@NotBlank String expression, @NotNull EvaluationContext evalContext) {
        Assert.notNull((Object)expression, (String)"\u8868\u8fbe\u5f0f\u4e3a\u7a7a");
        Assert.isTrue((boolean)(evalContext instanceof CloudtSpelEvaluationContext), (String)"\u6682\u4e0d\u652f\u6301\u7684evalContext\u5bf9\u8c61");
        CloudtSpelEvaluationContext context = (CloudtSpelEvaluationContext)evalContext;
        return this.getExpression(this.keyCache, context.getMethodKey(), expression).getValue(evalContext);
    }

    public Object parseExpression(@NotBlank String expression, @NotNull ProceedingJoinPoint joinPoint) {
        Assert.notNull((Object)expression, (String)"\u8868\u8fbe\u5f0f\u4e3a\u7a7a");
        Assert.notNull((Object)joinPoint, (String)"\u5904\u7406\u65b9\u6cd5\u4e3a\u7a7a");
        Method method = AspectUtil.getTargetMethod((JoinPoint)joinPoint);
        EvaluationContext context = this.createEvaluationContext(joinPoint.getTarget(), method, joinPoint.getArgs());
        return this.parseExpression(expression, context);
    }

    private CloudtSpelMetadata getCloudtSpelMetadata(Method method, Class<?> targetClass) {
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        CloudtSpelMetadata metadata = this.metadataCache.get(methodKey);
        if (metadata == null) {
            metadata = new CloudtSpelMetadata(method, targetClass);
            this.metadataCache.put(methodKey, metadata);
        }
        return metadata;
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    static class CloudtSpelEvaluationContext
    extends MethodBasedEvaluationContext {
        private final AnnotatedElementKey methodKey;

        public CloudtSpelEvaluationContext(Object rootObject, Method method, Object[] args, Object target, Class<?> targetClass, Method targetMethod, AnnotatedElementKey methodKey, ParameterNameDiscoverer parameterNameDiscoverer) {
            super(rootObject, targetMethod, args, parameterNameDiscoverer);
            this.methodKey = new AnnotatedElementKey((AnnotatedElement)targetMethod, targetClass);
        }

        public AnnotatedElementKey getMethodKey() {
            return this.methodKey;
        }
    }

    static class CloudtSpelRootObject {
        private final Method method;
        private final Object[] args;
        private final Object target;
        private final Class<?> targetClass;

        public CloudtSpelRootObject(Method method, Object[] args, Object target, Class<?> targetClass) {
            this.method = method;
            this.args = args;
            this.target = target;
            this.targetClass = targetClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getTarget() {
            return this.target;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public String getEnv(String key) {
            Assert.hasText((String)key, (String)"key\u4e3a\u7a7a");
            return SpringContextHolder.getProperty(key);
        }
    }

    static class CloudtSpelMetadata {
        private final Method method;
        private final Class<?> targetClass;
        private final Method targetMethod;
        private final AnnotatedElementKey methodKey;

        public CloudtSpelMetadata(Method method, Class<?> targetClass) {
            this.method = BridgeMethodResolver.findBridgedMethod((Method)method);
            this.targetClass = targetClass;
            this.targetMethod = !Proxy.isProxyClass(targetClass) ? AopUtils.getMostSpecificMethod((Method)method, targetClass) : this.method;
            this.methodKey = new AnnotatedElementKey((AnnotatedElement)this.targetMethod, targetClass);
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public Method getTargetMethod() {
            return this.targetMethod;
        }

        public AnnotatedElementKey getMethodKey() {
            return this.methodKey;
        }
    }
}

