/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.encrypt.BaseEncrypt;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.springframework.util.Assert;

public class RsaUtil
extends BaseEncrypt {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String DEFAULT_RANDOM_TYPE = "SHA1PRNG";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256WithRSA";
    private static final String DEFAULT_CIPHER_TYPE = "RSA/ECB/PKCS1Padding";
    private static final int DEFAULT_LEN_ENCRYPT = 245;
    private static final int DEFAULT_LEN_DECRYPT = 256;

    public static KeyPair generateKeyPair() {
        return RsaUtil.generateKeyPair(2048);
    }

    public static KeyPair generateKeyPair(int keySize) {
        SecureRandom random = RsaUtil.generateSecureRandom(DEFAULT_RANDOM_TYPE);
        return RsaUtil.generateKeyPair(KEY_ALGORITHM, keySize, random);
    }

    public static String convertKey2Str(@NotNull Key key) {
        Assert.notNull((Object)key, (String)"\u79d8\u94a5\u4e3a\u7a7a");
        return RsaUtil.encodeBase64Str(key.getEncoded());
    }

    public static PublicKey convert2PublicKey(@NotBlank String key) {
        KeyFactory keyFactory = RsaUtil.generateKeyFactory(KEY_ALGORITHM);
        return RsaUtil.convert2PublicKey(key, keyFactory);
    }

    public static PrivateKey convert2PrivateKey(@NotBlank String key) {
        KeyFactory keyFactory = RsaUtil.generateKeyFactory(KEY_ALGORITHM);
        return RsaUtil.convert2PrivateKey(key, keyFactory);
    }

    public static byte[] convert2Pkcs1(@NotNull PublicKey publicKey) {
        return ASN1BitString.getInstance((Object)ASN1Sequence.getInstance((Object)publicKey.getEncoded()).getObjectAt(1)).getBytes();
    }

    public static PublicKey convert2PublicKeyForPkcs1(@NotBlank String key) throws Exception {
        Assert.hasText((String)key, (String)"\u516c\u94a5\u4e3a\u7a7a");
        KeyFactory keyFactory = RsaUtil.generateKeyFactory(KEY_ALGORITHM);
        byte[] keys = RsaUtil.decodeBase64(key);
        try {
            RSAPublicKey rsaPublicKey = RSAPublicKey.getInstance((Object)keys);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent());
            return keyFactory.generatePublic(rsaPublicKeySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u516c\u94a5\u65e0\u6548\uff1a", e);
        }
    }

    public static byte[] convert2Pkcs1(@NotNull PrivateKey privateKey) throws IOException {
        return PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()).parsePrivateKey().toASN1Primitive().getEncoded();
    }

    public static PrivateKey convert2PrivateKeyForPkcs1(@NotBlank String key) throws Exception {
        Assert.hasText((String)key, (String)"\u79c1\u94a5\u4e3a\u7a7a");
        KeyFactory keyFactory = RsaUtil.generateKeyFactory(KEY_ALGORITHM);
        byte[] keys = RsaUtil.decodeBase64(key);
        try {
            RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)keys);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(rsaPrivateKey.getEncoded());
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u79c1\u94a5\u65e0\u6548\uff1a", e);
        }
    }

    public static String sign(@NotNull PrivateKey privateKey, String signatureAlgorithm, @NotBlank String plainText) {
        Signature signature = RsaUtil.generateSignature(CharSequenceUtil.blankToDefault((CharSequence)signatureAlgorithm, (String)DEFAULT_SIGNATURE_ALGORITHM));
        return RsaUtil.sign(privateKey, signature, plainText);
    }

    public static boolean verifySign(@NotNull PublicKey publicKey, String signatureAlgorithm, @NotBlank String plainText, @NotBlank String sign) {
        Signature signature = RsaUtil.generateSignature(CharSequenceUtil.blankToDefault((CharSequence)signatureAlgorithm, (String)DEFAULT_SIGNATURE_ALGORITHM));
        return RsaUtil.verifySign(publicKey, signature, plainText, sign);
    }

    public static String encrypt(@NotNull PublicKey publicKey, @NotBlank String cipherType, @NotBlank String plainText) {
        try {
            return RsaUtil.encrypt(publicKey, 245, null, CharSequenceUtil.blankToDefault((CharSequence)cipherType, (String)DEFAULT_CIPHER_TYPE), plainText);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff1a", e);
        }
    }

    public static String decrypt(@NotNull PrivateKey privateKey, @NotBlank String cipherType, @NotBlank String ciphertext) {
        try {
            return RsaUtil.decrypt(privateKey, 256, null, CharSequenceUtil.blankToDefault((CharSequence)cipherType, (String)DEFAULT_CIPHER_TYPE), ciphertext);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff1a", e);
        }
    }
}

