/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.encrypt;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Assert;

public abstract class BaseEncrypt {
    protected static final Charset CHARSET = StandardCharsets.UTF_8;

    public static String encodeBase64Str(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getDecoder().decode(data);
    }

    protected static SecureRandom generateSecureRandom(@NotBlank String secureRandomAlgorithm) {
        Assert.hasText((String)secureRandomAlgorithm, (String)"\u968f\u673a\u56e0\u5b50\u7b97\u6cd5\u540d\u79f0\u4e3a\u7a7a");
        try {
            return SecureRandom.getInstance(secureRandomAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u751f\u6210\u5b89\u5168\u968f\u673a\u56e0\u5b50\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u652f\u6301\u7b97\u6cd5" + secureRandomAlgorithm, e);
        }
    }

    protected static KeyPair generateKeyPair(@NotBlank String keyAlgorithm, int keySize, @NotNull SecureRandom secureRandom) {
        Assert.hasText((String)keyAlgorithm, (String)"\u79d8\u94a5\u7b97\u6cd5\u540d\u79f0\u4e3a\u7a7a");
        Assert.notNull((Object)secureRandom, (String)"\u968f\u673a\u56e0\u5b50\u4e3a\u7a7a");
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5" + keyAlgorithm);
        }
        generator.initialize(keySize, secureRandom);
        return generator.generateKeyPair();
    }

    protected static KeyFactory generateKeyFactory(@NotBlank String keyAlgorithm) {
        Assert.hasText((String)keyAlgorithm, (String)"\u79d8\u94a5\u7b97\u6cd5\u540d\u79f0\u4e3a\u7a7a");
        try {
            return KeyFactory.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("\u8bfb\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u652f\u6301" + keyAlgorithm, e);
        }
    }

    protected static PublicKey convert2PublicKey(@NotBlank String key, @NotNull KeyFactory keyFactory) {
        Assert.hasText((String)key, (String)"\u516c\u94a5\u4e3a\u7a7a");
        Assert.notNull((Object)keyFactory, (String)"\u516c\u94a5\u5de5\u5382\u4e3a\u7a7a");
        byte[] keys = BaseEncrypt.decodeBase64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keys);
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("\u516c\u94a5\u65e0\u6548\uff1a", e);
        }
    }

    protected static PrivateKey convert2PrivateKey(@NotBlank String key, @NotNull KeyFactory keyFactory) {
        Assert.hasText((String)key, (String)"\u79c1\u94a5\u4e3a\u7a7a");
        byte[] keys = BaseEncrypt.decodeBase64(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keys);
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("\u79c1\u94a5\u65e0\u6548\uff1a", e);
        }
    }

    protected static Signature generateSignature(@NotBlank String signatureAlgorithm) {
        Assert.hasText((String)signatureAlgorithm, (String)"\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0\u4e3a\u7a7a");
        try {
            return Signature.getInstance(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("\u83b7\u53d6\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u652f\u6301" + signatureAlgorithm, e);
        }
    }

    public static String sign(@NotNull PrivateKey privateKey, @NotNull Signature signature, @NotBlank String plainText) {
        Assert.notNull((Object)privateKey, (String)"\u79c1\u94a5\u4e3a\u7a7a");
        Assert.notNull((Object)signature, (String)"\u7b7e\u540d\u7b97\u6cd5\u4e3a\u7a7a");
        Assert.notNull((Object)plainText, (String)"\u5f85\u7b7e\u540d\u5185\u5bb9\u4e3a\u7a7a");
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("\u7b7e\u540d\u6570\u636e\u5931\u8d25\uff0c\u79c1\u94a5\u65e0\u6548\uff1a", e);
        }
        try {
            signature.update(plainText.getBytes(CHARSET));
        }
        catch (SignatureException e) {
            throw new IllegalStateException("\u7b7e\u540d\u6570\u636e\u5931\u8d25\uff1a", e);
        }
        try {
            return BaseEncrypt.encodeBase64Str(signature.sign());
        }
        catch (SignatureException e) {
            throw new IllegalStateException("\u7b7e\u540d\u6570\u636e\u5931\u8d25\uff1a", e);
        }
    }

    public static boolean verifySign(@NotNull PublicKey publicKey, @NotNull Signature signature, @NotBlank String plainText, @NotBlank String sign) {
        Assert.notNull((Object)publicKey, (String)"\u516c\u94a5\u4e3a\u7a7a");
        Assert.notNull((Object)signature, (String)"\u7b7e\u540d\u7b97\u6cd5\u4e3a\u7a7a");
        Assert.notNull((Object)plainText, (String)"\u660e\u6587\u5185\u5bb9\u4e3a\u7a7a");
        Assert.notNull((Object)sign, (String)"\u7b7e\u540d\u4e3a\u7a7a");
        try {
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("\u7b7e\u540d\u6570\u636e\u5931\u8d25\uff0c\u516c\u94a5\u65e0\u6548\uff1a", e);
        }
        try {
            signature.update(plainText.getBytes(CHARSET));
        }
        catch (SignatureException e) {
            throw new IllegalStateException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff1a", e);
        }
        try {
            return signature.verify(BaseEncrypt.decodeBase64(sign));
        }
        catch (SignatureException e) {
            throw new IllegalStateException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff1a", e);
        }
    }

    protected static String encrypt(Key key, Integer blockSize, String iv, String cipherType, String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherType);
        if (iv == null) {
            cipher.init(1, key);
        } else {
            cipher.init(1, key, new IvParameterSpec(iv.getBytes(CHARSET)));
        }
        byte[] data = plainText.getBytes(CHARSET);
        if (blockSize == null) {
            return BaseEncrypt.encodeBase64Str(cipher.doFinal(data));
        }
        byte[] result = BaseEncrypt.cipherBySplit(cipher, data, blockSize);
        return BaseEncrypt.encodeBase64Str(result);
    }

    protected static String decrypt(Key key, Integer blockSize, String iv, String cipherType, String cipherText) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherType);
        if (iv == null) {
            cipher.init(2, key);
        } else {
            cipher.init(2, key, new IvParameterSpec(iv.getBytes(CHARSET)));
        }
        byte[] data = BaseEncrypt.decodeBase64(cipherText);
        if (blockSize == null) {
            return new String(cipher.doFinal(BaseEncrypt.decodeBase64(cipherText)));
        }
        byte[] result = BaseEncrypt.cipherBySplit(cipher, data, blockSize);
        return new String(result);
    }

    private static byte[] cipherBySplit(Cipher cipher, byte[] data, Integer blockSize) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int dataLen = data.length;
        int size = 0;
        do {
            size = Math.min(blockSize, dataLen - offset);
            byte[] cache = cipher.doFinal(data, offset, size);
            out.write(cache);
        } while ((offset += blockSize.intValue()) < dataLen);
        return out.toByteArray();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

