package com.elitescloud.boot;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 云梯context属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/11
 */
@ConfigurationProperties(prefix = CloudtContextProperties.CONFIG_PREFIX)
public class CloudtContextProperties {
    public static final String CONFIG_PREFIX = "elitesland.context";

    /**
     * 项目编码
     */
    private String project;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 环境编码
     */
    private String env;

    /**
     * 环境名称
     */
    private String envName;

    /**
     * 服务器地址
     * 外部可访问的，如http://cloudt.elitescloud.com
     */
    private String serverAddr;

    /**
     * 当前服务名称
     */
    private String serverName;

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getServerAddr() {
        if (serverAddr != null && serverAddr.endsWith("/")) {
            return serverAddr.substring(0, serverAddr.length() - 1);
        }
        return serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}
