package com.elitescloud.boot;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.provider.TenantOrgProvider;
import com.elitescloud.boot.wrapper.Isolatable;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

/**
 * 租户的默认配置.
 * <p>
 * 未启用租户时的配置
 *
 * @author Kaiser（wang shao）
 * @date 3/23/2023
 */
@ConditionalOnTenant(enabled = false)
@Log4j2
public class CloudtTenantDefaultAutoConfiguration {

    public CloudtTenantDefaultAutoConfiguration() {
        log.info("未启用租户");
    }

    @Bean
    @ConditionalOnMissingBean
    public Isolatable defaultIsolatable() {
        return new Isolatable() {
            @Override
            public <R, T> R apply(Supplier<R> supplier, T param) {
                return supplier.get();
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value = TransactionWrapper.class)
    public TransactionWrapper defaultTransactionWrapper() {
        return new TransactionWrapper() {
            @Override
            public <R, T> R apply(Supplier<R> supplier, T param) {
                return supplier.get();
            }
        };
    }

    @Bean
    public com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider tenantDataIsolateProvider() {
        return new com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider() {
            @Override
            public <T> T byNone(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public <T> T byDefaultDirectly(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public <T> T byTenantDirectly(Supplier<T> supplier, SysTenantDTO tenantDTO) {
                return supplier.get();
            }

            @Override
            public <T> T byTenantDirectly(Supplier<T> executor, Long tenantId) {
                return executor.get();
            }

            @Override
            public <T> T byTenantDirectly(Supplier<T> executor, String tenantCode) {
                return executor.get();
            }

            @Override
            public <T> T byTenantUser(Supplier<T> supplier, SysUserDTO currentUser) {
                return supplier.get();
            }

            @Override
            public <T> T byTenant(Supplier<T> supplier, SysUserDTO currentUser) {
                return supplier.get();
            }

            @Override
            public <T> T byTenantAuto(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public <T> void byAllTenant(Supplier<T> supplier) {
                supplier.get();
            }
        };
    }

    @Bean
    public com.elitescloud.cloudt.core.tenant.support.TenantClientProvider tenantClientProvider() {
        return new com.elitescloud.cloudt.core.tenant.support.TenantClientProvider() {
            @Override
            public boolean enabledTenant() {
                return false;
            }

            @Override
            public SysTenantDTO getCurrentTenant() {
                return null;
            }

            @Override
            public SysTenantDTO getSessionTenant() {
                return null;
            }

            @Override
            public SysTenantDTO getTenant(Long sysTenantId) {
                return null;
            }

            @Override
            public SysTenantDTO getTenantByCode(String tenantCode) {
                return null;
            }

            @Override
            public List<SysTenantDTO> getAllTenants() {
                return Collections.emptyList();
            }

            @Override
            public SysTenantDTO obtainTenantFromRequest() {
                return null;
            }

            @Override
            public boolean isDefaultDomainRequest() {
                return true;
            }
        };
    }

    @Bean
    public TenantOrgProvider tenantOrgProvider() {
        return new TenantOrgProvider() {
            @Override
            public Long getCurrentTenantOrgId() {
                return null;
            }

            @Override
            public Long getSessionTenantOrgId() {
                return null;
            }
        };
    }

    @Bean
    public com.elitescloud.cloudt.core.tenant.support.TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider() {
        return new com.elitescloud.cloudt.core.tenant.support.TenantOrgDataIsolateProvider() {
            @Override
            public <T> T byNoTenantOrg(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public <T> T byCurrentTenantOrg(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public <T> T byTenantOrg(Supplier<T> supplier, Long tenantOrgId) {
                return supplier.get();
            }
        };
    }
}
