package com.elitescloud.boot.base;

import com.elitescloud.boot.constant.CommonConstant;
import org.slf4j.MDC;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 链路跟踪处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
public abstract class AbstractLogTraceHandler {

    /**
     * traceId前缀
     * 可使用项目名，方便知晓是从哪个系统发起的
     */
    private final String traceIdPrefix;

    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    protected AbstractLogTraceHandler(String traceIdPrefix) {
        this.traceIdPrefix = traceIdPrefix;
    }

    protected String putTraceId() {
        return putTraceId(null);
    }

    protected String putTraceId(String traceId) {
        if (traceId == null || traceId.trim().isEmpty()) {
            LocalDateTime now = LocalDateTime.now();

            traceId = traceIdPrefix + "." + FORMATTER.format(now);
        }
        MDC.put(CommonConstant.LOG_TRACE_ID, traceId);

        return traceId;
    }

    protected void clearTraceId() {
        MDC.remove(CommonConstant.LOG_TRACE_ID);
    }
}
