package com.elitescloud.boot.common.annotation;

import java.lang.annotation.*;

/**
 * 业务对象.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/30
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessObject {

    /**
     * 是否启用
     * <p>
     * 如果关闭表示这个业务对象不可用
     *
     * @return 是否启用
     */
    boolean enabled() default true;

    /**
     * 业务类型
     * <p>
     * 约定操作类型约定格式： 英文名称:中文名称
     * <p>
     * 可创建常量类维护 英文名称不空，中文不空，未来会强校验
     *
     * @return 业务类型
     */
    String businessType();

    /**
     * 业务类型描述
     * <p>
     * 中文描述
     *
     * @return 描述
     */
    String businessDescription() default "-";

    /**
     * 业务对象详情
     *
     * @return 业务对象详情
     * @deprecated 已弃用，改用 {@link #businessDescription()}
     */
    @Deprecated(since = "3.3.0")
    String businessObjectDetails() default "-";

    /**
     * 业务对象领域
     *
     * @return 业务对象领域
     */
    String businessObjectDomain() default "";

    /**
     * 业务对象do实体类
     * <p>
     * 用于获取实体元数据和数据列权限控制
     *
     * @return 业务对象do实体类
     */
    Class<?> businessDoClass() default Void.class;

    /**
     * 关联业务操作
     * <p>
     * 用于关联其它业务对象下的操作
     *
     * @return 业务操作编码
     */
    String[] refBusinessObjectOperations() default {};

    /**
     * 是否是公共资源
     *
     * @return 是否是公共资源
     */
    boolean publicResource() default false;

    /**
     * 是否支持租户
     *
     * @return 是否支持租户
     */
    boolean supportTenant() default true;
}
