package com.elitescloud.boot.common.annotation.businessobject;

import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;

/**
 * 业务参数值生成器.
 * <p>
 * 实现方法至少要有一个空的构造方法
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/1
 */
@FunctionalInterface
public interface BusinessParamValueKeyGenerator {

    /**
     * 生成业务参数值.
     *
     * @param request       当前请求
     * @param handlerMethod 处理方法
     * @param args          参数
     * @return 业务参数值
     */
    String generate(@NotNull HttpServletRequest request, @NotNull HandlerMethod handlerMethod, Object[] args);
}
