package com.elitescloud.boot.common.constant;

import cn.hutool.core.text.CharSequenceUtil;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

/**
 * MimeType常量.
 * <p>
 * 参考 {@link org.springframework.http.MediaType} 和 {@link org.springframework.util.MimeTypeUtils}
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public interface MimeTypeConstant {

    MimeType XLS = new MimeType("application", "vnd.ms-exce");
    MimeType XLSX = new MimeType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    MimeType DOC = new MimeType("application", "msword");
    MimeType DOCX = new MimeType("application", "vnd.openxmlformats-officedocument.wordprocessingml.document");
    MimeType PPT = new MimeType("application", "vnd.ms-powerpoint");
    MimeType PPTX = new MimeType("application", "vnd.openxmlformats-officedocument.presentationml.presentation");
    MimeType ZIP = new MimeType("application", "zip");
    MimeType EXE = new MimeType("application", "x-msdownload");
    MimeType SQL = new MimeType("application", "x-sql");

    /**
     * 转为mediaType
     * @param mimeType
     * @return
     */
    static MediaType parseMediaType(MimeType mimeType) {
        if (mimeType == null) {
            return null;
        }
        return MediaType.asMediaType(mimeType);
    }

    /**
     * 转为mediaType
     * @param mimeType
     * @return
     */
    static MediaType parseMediaType(String mimeType) {
        if (CharSequenceUtil.isBlank(mimeType)) {
            return null;
        }
        var types = mimeType.split("/");
        return types.length > 1 ? new MediaType(types[0], types[1]) : new MediaType(types[0]);
    }

    /**
     * 根据文件名后缀获取mimeType
     *
     * @param filename
     * @return
     */
    static MimeType getMimeTypeByFilename(String filename) {
        if (filename == null) {
            return null;
        }

        if (filename.endsWith(".xlsx")) {
            return XLSX;
        }
        if (filename.endsWith(".xls")) {
            return XLS;
        }
        if (filename.endsWith(".docx")) {
            return DOCX;
        }
        if (filename.endsWith(".doc")) {
            return DOC;
        }
        if (filename.endsWith(".pptx")) {
            return PPTX;
        }
        if (filename.endsWith(".ppt")) {
            return PPT;
        }
        if (filename.endsWith(".zip")) {
            return ZIP;
        }
        if (filename.endsWith(".exe")) {
            return EXE;
        }
        if (filename.endsWith(".sql")) {
            return SQL;
        }

        return null;
    }
}
