package com.elitescloud.boot.common.constant;

/**
 * 签名算法.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/5
 */
public enum SignatureAlgorithm {

    /**
     * PKCS #1 v1.5
     * <p>
     * 使用SHA-1哈希函数和RSA加密算法进行签名
     */
    SHA1withRSA(EncryptAlgorithm.RSA),
    /**
     * PKCS #1 v2.1 【推荐】
     * <p>
     * 使用SHA-256哈希函数和RSA加密算法进行签名。这是目前推荐使用的算法之一，因为SHA-1的安全性已经被削弱。
     */
    SHA256withRSA(EncryptAlgorithm.RSA),
    /**
     * PKCS #1 v2.1
     * <p>
     * 使用SHA-384哈希函数和RSA加密算法进行签名。
     */
    SHA384withRSA(EncryptAlgorithm.RSA),
    /**
     * PKCS #1 v2.1
     * <p>
     * 使用SHA-512哈希函数和RSA加密算法进行签名。由于其更长的输出长度，它提供了比SHA-256更高的安全性。
     */
    SHA512withRSA(EncryptAlgorithm.RSA),

    /**
     * PKCS #1 v1.5
     * <p>
     * 使用MD5哈希函数和RSA加密算法进行签名。但是，由于MD5的安全性问题，该算法不推荐使用。
     */
    MD5withRSA(EncryptAlgorithm.RSA),
    ;

    private final EncryptAlgorithm encryptAlgorithm;

    SignatureAlgorithm(EncryptAlgorithm encryptAlgorithm) {
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public EncryptAlgorithm getEncryptAlgorithm() {
        return encryptAlgorithm;
    }
}
