package com.elitescloud.boot.common.translate;

import com.elitescloud.boot.common.translate.translator.AbstractTranslatorCustomizer;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;

import javax.validation.constraints.NotNull;

/**
 * 自定义数据翻译器.
 * <p>
 * 可继承 {@link AbstractTranslatorCustomizer}
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/8
 */
public interface TranslatorCustomizer {

    /**
     * 翻译器编码
     * <p>
     * 需保证唯一
     *
     * @return 唯一编码
     */
    String code();

    /**
     * 翻译器名称
     *
     * @return 翻译器名称
     */
    default String name() {
        return null;
    }

    /**
     * 翻译数据
     *
     * @param data   待翻译的数据
     * @param tenant 当前租户信息
     */
    void translate(@NotNull Object data, SysTenantDTO tenant);

    /**
     * 是否支持递归
     *
     * @return 是否支持递归
     */
    default boolean supportRecursive() {
        return true;
    }
}
