package com.elitescloud.boot.support;

import com.elitescloud.boot.constant.ClassNameConstant;
import com.elitescloud.boot.util.ClassUtil;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * starter工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/9
 */
public final class CloudtStarterTool {
    private static String CONFIG_PREFIX_TENANT = "elitesland.tenant.client";

    private CloudtStarterTool() {
    }

    /**
     * 是否启用了租户
     *
     * @return 是否启用
     */
    public static boolean enabledTenant() {
        return isPresentClass(ClassNameConstant.TENANT_CLIENT, null);
    }

    /**
     * 是否启用了租户
     *
     * @return 是否启用
     */
    public static boolean enabledTenant(@NotNull Environment environment) {
        if (!enabledTenant()) {
            return false;
        }
        return isPresentEnvironment(environment, CONFIG_PREFIX_TENANT + ".enabled", "true", "true");
    }

    /**
     * 是否存在指定的类
     *
     * @param className   类的全限定名
     * @param classLoader classLoader
     * @return 是否存在
     */
    public static boolean isPresentClass(@NotBlank String className, ClassLoader classLoader) {
        return ClassUtil.isPresent(className, classLoader);
    }

    /**
     * 是否存在指定的配置
     *
     * @param environment 环境
     * @param key         属性key
     * @param expectValue 期望值
     * @return 是否存在
     */
    public static boolean isPresentEnvironment(@NonNull Environment environment, @NonNull String key, String defaultValue, String expectValue) {
        Object val = environment.getProperty(key, defaultValue);
        if (expectValue == null) {
            return val != null;
        }

        return val != null && val.toString().equals(expectValue);
    }
}
