package com.elitescloud.boot.util;

import com.elitescloud.boot.util.encrypt.BaseEncrypt;

import javax.crypto.spec.SecretKeySpec;

/**
 * AES加解密工具.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class AesUtil extends BaseEncrypt {

    /**
     * 加密算法
     */
    private static final String ENCRYPT_ALGORITHM = "AES";

    /**
     * 加密算法、工作模式和填充模式
     */
    private static final String CIPHER_TYPE = "AES/CBC/PKCS7Padding";

    private AesUtil() {
    }

    /**
     * 数据加密
     *
     * @param secret    密码
     * @param iv        偏移量
     * @param plainText 明文
     * @return 密文
     */
    public static String encrypt(String secret, String iv, String plainText) {
        SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(CHARSET), ENCRYPT_ALGORITHM);
        try {
            return encrypt(keySpec, null, iv, CIPHER_TYPE, plainText);
        } catch (Exception e) {
            throw new RuntimeException("数据加密失败：", e);
        }
    }


    /**
     * 数据解密
     *
     * @param secret     密码
     * @param iv         偏移量
     * @param cipherText 密文
     * @return 明文
     */
    public static String decrypt(String secret, String iv, String cipherText) {
        SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(CHARSET), ENCRYPT_ALGORITHM);
        try {
            return decrypt(keySpec, null, iv, CIPHER_TYPE, cipherText);
        } catch (Exception e) {
            throw new RuntimeException("数据解密失败：", e);
        }
    }
}
