package com.elitescloud.boot.util;

import java.math.BigDecimal;

/**
 * 数字工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/13
 */
public class NumberUtil extends cn.hutool.core.util.NumberUtil {

    /**
     * 求绝对值
     *
     * @param num1 数字1
     * @param num2 数字2
     * @return 绝对值
     */
    public static BigDecimal abs(BigDecimal num1, BigDecimal num2) {
        if (num1 == null) {
            return num2 == null ? BigDecimal.ZERO : num2.abs();
        }
        if (num2 == null) {
            return num1.abs();
        }

        return num1.subtract(num2).abs();
    }
}
