package com.elitescloud.cloudt.context.util.database;

import org.springframework.orm.jpa.vendor.Database;

/**
 * 数据库工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/9
 */
public class SqlUtil {

    /**
     * 生成切换schema的SQL
     *
     * @param databaseType 数据库类型
     * @param schema       schema
     * @return SQL
     */
    public static String generateSwitchSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL:
            case SQL_SERVER:
                return String.format("USE %s", schema);
            case ORACLE:
                return String.format("ALTER SESSION SET CURRENT_SCHEMA = \"%s\"", schema);
            case POSTGRESQL:
                return String.format("SET SEARCH_PATH TO '%s'", schema);
            default:
                throw new IllegalStateException("暂不支持数据库：" + databaseType.name());
        }
    }

    /**
     * 生成判断schema是否存在的SQL
     *
     * @param databaseType 数据库类型
     * @param schema       schema
     * @return SQL
     */
    public static String generateExistsSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL:
                return String.format("SELECT * FROM information_schema.schemata WHERE schema_name='%s' LIMIT 1", schema);
            case ORACLE:
                return String.format("SELECT * FROM ALL_USERS WHERE USERNAME = '%s'", schema);
            case POSTGRESQL:
                return String.format("SELECT EXISTS(SELECT 1 FROM PG_NAMESPACE WHERE NSPNAME = '%s')", schema);
            default:
                throw new IllegalStateException("暂不支持数据库：" + databaseType.name());
        }
    }

    /**
     * 生成删除schema的SQL
     *
     * @param databaseType 数据库类型
     * @param schema       schema
     * @return SQL
     */
    public static String generateDropSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL:
                return String.format("DROP SCHEMA `%s`", schema);
            case ORACLE:
                return String.format("DROP USER \"%s\" CASCADE", schema);
            case POSTGRESQL:
                return String.format("DROP SCHEMA IF EXISTS %s CASCADE", schema);
            default:
                throw new IllegalStateException("暂不支持数据库：" + databaseType.name());
        }
    }
}
