/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot;

import com.elitescloud.boot.CloudtSpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpringContextHolder {
    private static final Map<Class<?>, Object> beanCache = new HashMap();

    protected SpringContextHolder() {
    }

    public static boolean initialized() {
        return CloudtSpringContextHolder.getApplicationContext() != null;
    }

    public static <T> T getBean(Class<T> clazz) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        Object bean = beanCache.get(clazz);
        if (bean != null) {
            return (T)bean;
        }
        bean = applicationContext.getBean(clazz);
        beanCache.put(clazz, bean);
        return (T)bean;
    }

    public static Object getBean(String name) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.hasText((String)name, (String)"bean\u540d\u79f0\u4e3a\u7a7a");
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.hasText((String)name, (String)"bean\u540d\u79f0\u4e3a\u7a7a");
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return (T)applicationContext.getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeans(Class<T> clazz) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return applicationContext.getBeansOfType(clazz);
    }

    public static Map<String, Object> getBeansByAnnotation(@NotNull Class<? extends Annotation> annotationClass) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.notNull(annotationClass, (String)"\u6ce8\u89e3\u7c7b\u578b\u4e3a\u7a7a");
        return applicationContext.getBeansWithAnnotation(annotationClass);
    }

    public static <T> ObjectProvider<T> getObjectProvider(Class<T> clazz) {
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return applicationContext.getBeanProvider(clazz);
    }

    public static String getProperty(String key) {
        return SpringContextHolder.getProperty(key, String.class, null);
    }

    public static String getProperty(String key, String defaultValue) {
        return SpringContextHolder.getProperty(key, String.class, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> valueType) {
        return SpringContextHolder.getProperty(key, valueType, null);
    }

    public static <T> T getProperty(String key, Class<T> valueType, T defaultValue) {
        Assert.hasText((String)key, (String)"key\u4e3a\u7a7a");
        Assert.notNull(valueType, (String)"\u503c\u7c7b\u578b\u4e3a\u7a7a");
        Environment environment = SpringContextHolder.getBean(Environment.class);
        Object value = environment.getProperty(key, valueType);
        if (defaultValue == null) {
            return (T)value;
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String && !StringUtils.hasText((String)((String)value))) {
            return defaultValue;
        }
        return (T)value;
    }

    public static Resource getResource(String location) {
        Assert.hasText((String)location, (String)"location\u4e3a\u7a7a");
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        return applicationContext.getResource(location);
    }

    public static Resource[] getResources(String locationPattern) {
        Assert.hasText((String)locationPattern, (String)"locationPattern\u4e3a\u7a7a");
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        try {
            return applicationContext.getResources(locationPattern);
        }
        catch (IOException e) {
            throw new BusinessException("\u83b7\u53d6\u8d44\u6e90\u6587\u4ef6\u3010" + locationPattern + "\u3011\u5931\u8d25", (Throwable)e);
        }
    }

    public static String getApplicationName() {
        return SpringContextHolder.getProperty("spring.application.name");
    }

    public static void autowireBean(Object bean) {
        Assert.notNull((Object)bean, (String)"\u5bf9\u8c61\u4e3a\u7a7a");
        ApplicationContext applicationContext = SpringContextHolder.assertContextInjected();
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
    }

    public static Class<?> getMainClass() {
        SpringApplication springApplication = SpringContextHolder.assertApplicationInjected();
        return springApplication.getMainApplicationClass();
    }

    private static ApplicationContext assertContextInjected() {
        ApplicationContext applicationContext = CloudtSpringContextHolder.getApplicationContext();
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"\u8bf7\u5148\u8bbe\u7f6eapplicationContext.");
        return applicationContext;
    }

    private static SpringApplication assertApplicationInjected() {
        SpringApplication springApplication = CloudtSpringContextHolder.getSpringApplication();
        Assert.state((springApplication != null ? 1 : 0) != 0, (String)"\u8bf7\u5148\u8bbe\u7f6espringApplication.");
        return springApplication;
    }
}

