/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanWrapperUtil {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(BeanWrapperUtil.class);
    private static final Map<Class<?>, TypeWrapper> WRAPPER_MAP = new HashMap(512);

    public static Map<String, Object> getFieldValue(@NotNull Object data, @NotEmpty String[] fieldNames) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notEmpty((Object[])fieldNames, (String)"\u4fee\u6539\u7684\u5c5e\u6027\u4e3a\u7a7a");
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)data);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(fieldNames.length);
        for (String fieldName : fieldNames) {
            valueMap.put(fieldName, propertyAccessor.getPropertyValue(fieldName));
        }
        return valueMap;
    }

    public static void updateFieldValue(@NotNull Object data, @NotEmpty Map<String, Object> fieldValues) {
        BeanWrapperUtil.updateFieldValue(data, fieldValues, false);
    }

    public static void updateFieldValue(@NotNull Object data, @NotEmpty Map<String, Object> fieldValues, boolean ignoreException) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notEmpty(fieldValues, (String)"\u4fee\u6539\u7684\u5c5e\u6027\u503c\u4e3a\u7a7a");
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)data);
        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            if (!StringUtils.hasText((String)entry.getKey()) || !propertyAccessor.isWritableProperty(entry.getKey())) continue;
            try {
                propertyAccessor.setPropertyValue(entry.getKey(), entry.getValue());
            }
            catch (BeansException e) {
                logger.error("\u4fee\u6539\u5c5e\u6027\u503c\u5f02\u5e38\uff1a{}\uff0c{}", (Object)entry.getKey(), entry.getValue());
                if (ignoreException) continue;
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static void updateFieldValue(@NotNull Object data, @NotEmpty String[] fieldNames, Function<Class<?>, Object> fieldValueFunction) {
        BeanWrapperUtil.updateFieldValue(data, fieldNames, fieldValueFunction, false);
    }

    public static void updateFieldValue(@NotNull Object data, @NotEmpty String[] fieldNames, Function<Class<?>, Object> fieldValueFunction, boolean ignoreException) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notEmpty((Object[])fieldNames, (String)"\u4fee\u6539\u7684\u5c5e\u6027\u4e3a\u7a7a");
        Assert.notNull(fieldValueFunction, (String)"\u83b7\u53d6\u503c\u7684\u65b9\u6cd5\u4e3a\u7a7a");
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)data);
        Class fieldType = null;
        Object value = null;
        for (String fieldName : fieldNames) {
            if (!StringUtils.hasText((String)fieldName) || !propertyAccessor.isWritableProperty(fieldName)) continue;
            fieldType = propertyAccessor.getPropertyType(fieldName);
            if (fieldType == null) {
                logger.warn("\u5c5e\u6027\u4e0d\u5b58\u5728\uff1a{}", (Object)fieldName);
                continue;
            }
            value = fieldValueFunction.apply(fieldType);
            try {
                propertyAccessor.setPropertyValue(fieldName, value);
            }
            catch (BeansException e) {
                logger.error("\u4fee\u6539\u5c5e\u6027\u503c\u5f02\u5e38\uff1a{}\uff0c{}", (Object)fieldName, value);
                if (ignoreException) continue;
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static List<CustomField> getFields(@NotNull Object data) {
        return BeanWrapperUtil.getFields(data, true);
    }

    public static List<CustomField> getFields(@NotNull Object data, boolean withParent) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        return BeanWrapperUtil.getFields(data, null, withParent);
    }

    public static CustomField getField(@NotNull Object data, @NotBlank String fieldName) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a");
        FieldWrapper field = BeanWrapperUtil.getTypeWrapper((Object)data).fieldNames.get(fieldName);
        return field == null ? null : field.toCustomField();
    }

    public static List<CustomField> getFieldsByAnnotation(@NotNull Object data, @NotNull Class<? extends Annotation> annotation) {
        return BeanWrapperUtil.getFieldsByAnnotation(data, annotation, true);
    }

    public static List<CustomField> getFieldsByAnnotation(@NotNull Object data, @NotNull Class<? extends Annotation> annotation, boolean withParent) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notNull(annotation, (String)"\u6ce8\u89e3\u7c7b\u578b\u4e3a\u7a7a");
        return BeanWrapperUtil.getFields(data, annotation, withParent);
    }

    public static <T extends Annotation> T getAnnotation(@NotNull Field field, @NotNull Class<T> annotationType) {
        List<T> annotations = BeanWrapperUtil.getAnnotations(field, annotationType);
        return (T)(annotations.isEmpty() ? null : (Annotation)annotations.get(0));
    }

    public static <T extends Annotation> T getAnnotation(@NotNull Object data, @NotBlank String fieldName, @NotNull Class<T> annotationType) {
        List<T> annotations = BeanWrapperUtil.getAnnotations(data, fieldName, annotationType);
        return (T)(annotations.isEmpty() ? null : (Annotation)annotations.get(0));
    }

    public static <T extends Annotation> List<T> getAnnotations(@NotNull Field field, @NotNull Class<T> annotationType) {
        Assert.notNull((Object)field, (String)"\u5c5e\u6027\u4e3a\u7a7a");
        Assert.notNull(annotationType, (String)"\u6ce8\u89e3\u7c7b\u578b\u4e3a\u7a7a");
        Class<?> clazz = field.getDeclaringClass();
        FieldWrapper fieldWrapper = BeanWrapperUtil.getTypeWrapper(clazz).fields.get(field);
        if (fieldWrapper == null) {
            return Collections.emptyList();
        }
        return fieldWrapper.toCustomField().getAnnotations(annotationType);
    }

    public static <T extends Annotation> List<T> getAnnotations(@NotNull Object data, @NotBlank String fieldName, @NotNull Class<T> annotationType) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"\u5c5e\u6027\u4e3a\u7a7a");
        Assert.notNull(annotationType, (String)"\u6ce8\u89e3\u7c7b\u578b\u4e3a\u7a7a");
        FieldWrapper fieldWrapper = BeanWrapperUtil.getTypeWrapper((Object)data).fieldNames.get(fieldName);
        if (fieldWrapper == null) {
            return Collections.emptyList();
        }
        return fieldWrapper.toCustomField().getAnnotations(annotationType);
    }

    public static Method getReadMethod(@NotNull Object data, @NotNull Field field) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notNull((Object)field, (String)"\u5c5e\u6027\u4e3a\u7a7a");
        FieldWrapper fieldWrapper = BeanWrapperUtil.getFieldByField(data, field);
        return fieldWrapper == null ? null : fieldWrapper.readMethod;
    }

    public static Method getReadMethod(@NotNull Object data, @NotBlank String fieldName) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a");
        FieldWrapper fieldWrapper = BeanWrapperUtil.getFieldByFieldName(data, fieldName);
        return fieldWrapper == null ? null : fieldWrapper.readMethod;
    }

    public static Method getWriteMethod(@NotNull Object data, @NotNull Field field) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.notNull((Object)field, (String)"\u5c5e\u6027\u4e3a\u7a7a");
        FieldWrapper fieldWrapper = BeanWrapperUtil.getFieldByField(data, field);
        return fieldWrapper == null ? null : fieldWrapper.writeMethod;
    }

    public static Method getWriteMethod(@NotNull Object data, @NotBlank String fieldName) {
        Assert.notNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a");
        FieldWrapper fieldWrapper = BeanWrapperUtil.getFieldByFieldName(data, fieldName);
        return fieldWrapper == null ? null : fieldWrapper.writeMethod;
    }

    private static FieldWrapper getFieldByFieldName(@NotNull Object data, String fieldName) {
        return BeanWrapperUtil.getTypeWrapper((Object)data).fieldNames.get(fieldName);
    }

    private static FieldWrapper getFieldByField(@NotNull Object data, Field field) {
        return BeanWrapperUtil.getTypeWrapper((Object)data).fields.get(field);
    }

    private static List<CustomField> getFields(@NotNull Object data, Class<? extends Annotation> annotation, boolean includeInherit) {
        TypeWrapper typeWrapper = BeanWrapperUtil.getTypeWrapper(data);
        if (typeWrapper.simpleType) {
            return Collections.emptyList();
        }
        ArrayList<CustomField> fields = new ArrayList<CustomField>(8);
        for (Map.Entry<Field, FieldWrapper> entry : typeWrapper.fields.entrySet()) {
            if (!includeInherit && entry.getValue().inherit) continue;
            if (annotation == null) {
                fields.add(entry.getValue().toCustomField());
                continue;
            }
            if (!entry.getValue().annotations.containsKey(annotation)) continue;
            fields.add(entry.getValue().toCustomField());
        }
        return fields;
    }

    private static TypeWrapper getTypeWrapper(Object obj) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        TypeWrapper typeWrapper = WRAPPER_MAP.get(clazz);
        if (typeWrapper == null) {
            typeWrapper = new TypeWrapper(clazz);
            WRAPPER_MAP.put(clazz, typeWrapper);
        }
        return typeWrapper;
    }

    static class TypeWrapper {
        private final Class<?> clazz;
        private boolean simpleType;
        private Map<Field, FieldWrapper> fields;
        private Map<String, FieldWrapper> fieldNames;

        TypeWrapper(Class<?> clazz) {
            Assert.notNull(clazz, (String)"\u7c7b\u578b\u4e3a\u7a7a");
            this.clazz = clazz;
            this.analyze();
        }

        private void analyze() {
            this.simpleType = ClassUtil.isSimpleValueType(this.clazz);
            if (this.simpleType) {
                this.fields = Collections.emptyMap();
                this.fieldNames = Collections.emptyMap();
                return;
            }
            Object[] originalFields = ReflectUtil.getFields(this.clazz);
            if (ArrayUtil.isEmpty((Object[])originalFields)) {
                this.fields = Collections.emptyMap();
                this.fieldNames = Collections.emptyMap();
                return;
            }
            Map<String, PropertyDescriptor> propertyDesciptorMap = Arrays.stream(BeanUtils.getPropertyDescriptors(this.clazz)).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity(), (t1, t2) -> t1));
            this.fields = new HashMap<Field, FieldWrapper>(originalFields.length);
            this.fieldNames = new HashMap<String, FieldWrapper>(originalFields.length);
            for (Object field : originalFields) {
                if (Modifier.isStatic(((Field)field).getModifiers()) || this.fieldNames.containsKey(((Field)field).getName())) continue;
                FieldWrapper fieldWrapper = new FieldWrapper(this.clazz, (Field)field, propertyDesciptorMap);
                this.fields.put((Field)field, fieldWrapper);
                this.fieldNames.put(((Field)field).getName(), fieldWrapper);
            }
        }
    }

    static class FieldWrapper {
        private final Field field;
        private boolean inherit;
        private Method readMethod;
        private Method writeMethod;
        private Map<Class<? extends Annotation>, List<Annotation>> annotations;

        FieldWrapper(Class<?> clazz, Field field, Map<String, PropertyDescriptor> propertyDescriptorMap) {
            Assert.notNull((Object)field, (String)"\u5c5e\u6027\u4e3a\u7a7a");
            this.field = field;
            this.analyze(clazz, propertyDescriptorMap);
        }

        private void analyze(Class<?> clazz, Map<String, PropertyDescriptor> propertyDescriptorMap) {
            Object[] annotationsOriginal;
            this.inherit = this.field.getDeclaringClass() != clazz;
            PropertyDescriptor propertyDescriptor = propertyDescriptorMap.get(this.field.getName());
            if (propertyDescriptor != null) {
                this.readMethod = propertyDescriptor.getReadMethod();
                this.writeMethod = propertyDescriptor.getWriteMethod();
            }
            if (ArrayUtil.isEmpty((Object[])(annotationsOriginal = this.field.getAnnotations()))) {
                this.annotations = Collections.emptyMap();
            } else {
                this.annotations = new HashMap<Class<? extends Annotation>, List<Annotation>>(annotationsOriginal.length);
                for (Object annotation : annotationsOriginal) {
                    this.annotations.computeIfAbsent(annotation.annotationType(), t -> new ArrayList(4)).add(annotation);
                }
            }
        }

        public CustomField toCustomField() {
            return new CustomField(this);
        }
    }

    public static class CustomField {
        private final Field field;
        private final Method readMethod;
        private final Method writeMethod;
        private final Map<Class<? extends Annotation>, List<Annotation>> annotations;

        private CustomField() {
            this.field = null;
            this.readMethod = null;
            this.writeMethod = null;
            this.annotations = null;
        }

        private CustomField(FieldWrapper fieldWrapper) {
            this.field = fieldWrapper.field;
            this.readMethod = fieldWrapper.readMethod;
            this.writeMethod = fieldWrapper.writeMethod;
            this.annotations = this.cloneAnnotations(fieldWrapper.annotations);
        }

        private Map<Class<? extends Annotation>, List<Annotation>> cloneAnnotations(Map<Class<? extends Annotation>, List<Annotation>> source) {
            if (source.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<Class<? extends Annotation>, List<Annotation>> target = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            for (Map.Entry<Class<? extends Annotation>, List<Annotation>> entry : source.entrySet()) {
                target.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            return target;
        }

        public Field getField() {
            return this.field;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public Map<Class<? extends Annotation>, List<Annotation>> getAnnotations() {
            return this.annotations;
        }

        public String getName() {
            return this.field.getName();
        }

        public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationType) {
            List<T> annotations = this.getAnnotations(annotationType);
            return (T)(annotations.isEmpty() ? null : (Annotation)annotations.get(0));
        }

        public <T extends Annotation> List<T> getAnnotations(@NotNull Class<T> annotationType) {
            return this.annotations.getOrDefault(annotationType, Collections.emptyList());
        }

        public String toString() {
            return this.field.getDeclaringClass().getName() + "." + this.field.getName();
        }
    }
}

