/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class BusinessObjectUtil {
    private BusinessObjectUtil() {
    }

    public static String obtainBusinessObjectCode(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String businessObjectCode = request.getHeader("X-Cloudt-BusinessObject");
        if (StringUtils.hasText((String)businessObjectCode)) {
            return businessObjectCode;
        }
        BusinessObject businessObject = (BusinessObject)request.getAttribute("cloudt-businessObject");
        BusinessObjectOperation businessOperation = (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        if (businessOperation == null && businessObject == null) {
            return null;
        }
        if (businessOperation != null) {
            if ("@BusinessObject".equals(businessOperation.businessObjectType())) {
                return businessObject == null ? null : businessObject.businessType().split(":")[0];
            }
            return businessOperation.businessObjectType().split(":")[0];
        }
        return businessObject.businessType().split(":")[0];
    }

    public static String obtainBusinessOperationCode(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String businessOperationCode = request.getHeader("X-Cloudt-BusinessOperation");
        if (StringUtils.hasText((String)businessOperationCode)) {
            return businessOperationCode;
        }
        BusinessObjectOperation businessOperation = (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        if (businessOperation == null) {
            return null;
        }
        return StringUtils.hasText((String)businessOperation.operationCode()) ? businessOperation.operationCode() : null;
    }
}

