/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtil {
    private static final Logger logger = LoggerFactory.getLogger(CronUtil.class);

    private CronUtil() {
    }

    public static boolean validateCronExpression(String cronExpression) {
        if (StrUtil.isBlank((CharSequence)cronExpression)) {
            return false;
        }
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public static List<Date> getNextTriggerTimes(String cron, int times) {
        return CronUtil.getNextTriggerTimes(cron, times, null);
    }

    public static List<Date> getNextTriggerTimes(String cron, int times, Predicate<Date> validator) {
        if (StrUtil.isBlank((CharSequence)cron) || times <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Date> triggerTimes = null;
        try {
            CronExpression cronExpression = new CronExpression(cron);
            triggerTimes = new ArrayList<Date>(times);
            Date afterTime = new Date();
            while (triggerTimes.size() < times) {
                afterTime = cronExpression.getNextValidTimeAfter(afterTime);
                if (validator == null || validator.test(afterTime)) {
                    triggerTimes.add(afterTime);
                    continue;
                }
                logger.info("cron\u8868\u8fbe\u5f0f\uff1a{}\uff0c\u4e0b\u4e00\u6b21\u89e6\u53d1\u65f6\u95f4\uff1a{}\uff0c\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u8df3\u8fc7", (Object)cron, (Object)DatetimeUtil.toStr((Date)afterTime));
            }
        }
        catch (ParseException e) {
            throw new BusinessException("\u83b7\u53d6\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        return triggerTimes;
    }
}

