/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.core.provider;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.IdFactory;
import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.slf4j.Logger;

public class IdGenerator
implements IdentifierGenerator {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(IdGenerator.class);
    private Boolean alwaysCreate;

    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        Long id;
        boolean alwaysCreate = this.isAlwaysCreate();
        if (!alwaysCreate && o instanceof BaseModel && (id = ((BaseModel)o).getId()) != null && id >= 0L) {
            return id;
        }
        return IdFactory.generate();
    }

    public static Serializable generate() {
        return IdFactory.generate();
    }

    public static Long generateLong() {
        return IdFactory.generateLong();
    }

    private boolean isAlwaysCreate() {
        if (this.alwaysCreate == null) {
            this.alwaysCreate = SpringContextHolder.getProperty("elitesland.id.always-create", Boolean.class, false);
        }
        return this.alwaysCreate;
    }
}

