/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.constant.CronMonth;
import com.elitescloud.boot.util.cron.terms.AbstractCronTerm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MonthCronTerm
extends AbstractCronTerm {
    private Boolean every;
    private Set<CronMonth> specificValues;
    private AbstractCronTerm.RangeValue rangeValue;
    private AbstractCronTerm.RateValue rateValue;

    public MonthCronTerm(CronBuilder cronBuilder) {
        super(cronBuilder);
    }

    public MonthCronTerm every() {
        this.every = true;
        return this;
    }

    public MonthCronTerm of(CronMonth ... months) {
        if (months == null || months.length == 0) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<CronMonth>(60);
        }
        this.specificValues.addAll(Arrays.asList(months));
        return this;
    }

    public MonthCronTerm of(List<CronMonth> months) {
        if (months == null || months.isEmpty()) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<CronMonth>(60);
        }
        this.specificValues.addAll(months);
        return this;
    }

    public MonthCronTerm ofRange(CronMonth start, CronMonth end) {
        Assert.notNull((Object)((Object)start), (String)"\u6708\u7684\u5f00\u59cb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)end), (String)"\u6708\u7684\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rangeValue = new AbstractCronTerm.RangeValue(start.getValue(), end.getValue());
        return this;
    }

    public MonthCronTerm ofRate(CronMonth start, int rate) {
        Assert.notNull((Object)((Object)start), (String)"\u6708\u7684\u5f00\u59cb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rateValue = new AbstractCronTerm.RateValue(start.getValue(), rate);
        return this;
    }

    public MonthCronTerm ofRate(int rate) {
        this.rateValue = new AbstractCronTerm.RateValue(rate);
        return this;
    }

    @Override
    public String buildExpression() {
        if (Boolean.TRUE.equals(this.every)) {
            return "*";
        }
        if (CollUtil.isNotEmpty(this.specificValues)) {
            return this.specificValues.stream().map(CronMonth::getValue).peek(this::validateValue).sorted().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (this.rangeValue != null) {
            this.validateValue(this.rangeValue.getStart());
            this.validateValue(this.rangeValue.getEnd());
            if (this.rangeValue.getStart() > this.rangeValue.getEnd()) {
                throw new IllegalArgumentException("\u6708\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
            return this.rangeValue.getStart() + "-" + this.rangeValue.getEnd();
        }
        if (this.rateValue != null) {
            if (this.rateValue.getStart() != null) {
                this.validateValue(this.rateValue.getStart());
            }
            this.validateValue(this.rateValue.getRate());
            return String.valueOf(ObjUtil.defaultIfNull((Object)this.rateValue.getStart(), (Object)"*")) + "/" + this.rateValue.getRate();
        }
        return "*";
    }

    private void validateValue(int value) {
        Assert.isTrue((value >= 1 && value <= 12 ? 1 : 0) != 0, (String)"\u6708\u7684\u503c\u8303\u56f41-12", (Object[])new Object[0]);
    }
}

