/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.context;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.spi.TenantContextSpi;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class TenantContextHolder {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(TenantContextHolder.class);
    private static boolean enabledTenant;
    private static final List<TenantContextSpi> SPI_LIST;
    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT;

    private TenantContextHolder() {
    }

    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull((Object)tenant, (String)"\u5f53\u524d\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a");
        CURRENT_TENANT.set(tenant);
        TenantContextHolder.invokeSpiInstance(spi -> spi.onSetTenant(tenant));
    }

    public static void clearCurrentTenant() {
        SysTenantDTO tenant = CURRENT_TENANT.get();
        if (tenant == null) {
            return;
        }
        CURRENT_TENANT.remove();
        TenantContextHolder.invokeSpiInstance(spi -> spi.onClearTenant(tenant));
    }

    public static boolean isEnabledTenant() {
        return enabledTenant;
    }

    static void setEnabledTenant(boolean enabledTenant) {
        TenantContextHolder.enabledTenant = enabledTenant;
    }

    private static void invokeSpiInstance(Consumer<TenantContextSpi> supplier) {
        for (TenantContextSpi tenantContextSpi : SPI_LIST) {
            try {
                supplier.accept(tenantContextSpi);
            }
            catch (Throwable e) {
                logger.error("\u6267\u884c\u79df\u6237\u4e0a\u4e0b\u6587\u8bbe\u7f6e\u56de\u8c03\u5f02\u5e38\uff1a", e);
            }
        }
    }

    private static void loadSpiInstances() {
        ServiceLoader<TenantContextSpi> spiInstances = ServiceLoader.load(TenantContextSpi.class);
        if (CollUtil.isEmpty(spiInstances)) {
            return;
        }
        for (TenantContextSpi spiInstance : spiInstances) {
            SPI_LIST.add(spiInstance);
        }
    }

    static {
        SPI_LIST = new ArrayList<TenantContextSpi>();
        CompletableFuture.runAsync(TenantContextHolder::loadSpiInstances).whenComplete((r, e) -> {
            if (e == null) {
                logger.info("loaded {} TenantContextSpi instances successfully", (Object)SPI_LIST.size());
                return;
            }
            logger.error("\u52a0\u8f7dTenantContextSpi\u5931\u8d25\uff1a", e);
        });
        CURRENT_TENANT = new ThreadLocal();
    }
}

