/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class ObjUtil
extends ObjectUtil {
    private ObjUtil() {
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ApiResult) {
            return ObjUtil.isEmpty(((ApiResult)obj).getData());
        }
        if (obj instanceof PagingVO) {
            return ((PagingVO)obj).isEmpty();
        }
        return ObjectUtil.isEmpty((Object)obj);
    }

    public static <T> void ifNotNull(T value, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T> void ifNull(T value, T defaultValue, @NotNull Consumer<T> consumer) {
        ObjUtil.ifNull(value, () -> defaultValue, consumer);
    }

    public static <T> void ifNull(T value, Supplier<T> defaultValue, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value == null) {
            consumer.accept(defaultValue.get());
        }
    }

    public static void ifNotBlank(String value, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (StringUtils.hasText((String)value)) {
            consumer.accept(value);
        }
    }

    public static void ifBlank(String value, String defaultValue, @NotNull Consumer<String> consumer) {
        ObjUtil.ifBlank(value, () -> defaultValue, consumer);
    }

    public static void ifBlank(String value, Supplier<String> defaultValue, @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            return;
        }
        if (!StringUtils.hasText((String)value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(Collection<T> value, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(Collection<T> value, Collection<T> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(Collection<T> value, Supplier<Collection<T>> defaultValue, @NotNull Consumer<Collection<T>> consumer) {
        if (consumer == null) {
            return;
        }
        if (CollUtil.isEmpty(value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void ifNotEmpty(T[] value, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isNotEmpty((Object[])value)) {
            consumer.accept(value);
        }
    }

    public static <T> void ifEmpty(T[] value, T[] defaultValue, @NotNull Consumer<T[]> consumer) {
        ObjUtil.ifEmpty(value, () -> defaultValue, consumer);
    }

    public static <T> void ifEmpty(T[] value, Supplier<T[]> defaultValue, @NotNull Consumer<T[]> consumer) {
        if (consumer == null) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])value)) {
            consumer.accept(defaultValue.get());
        }
    }

    public static <T> void unwrap(Object wrappedObj, @NotNull Consumer<T> objConsumer) {
        Class<?> clazz = null;
        if (wrappedObj == null || ClassUtil.isSimpleValueType(clazz = wrappedObj.getClass())) {
            return;
        }
        if (wrappedObj instanceof ApiResult) {
            ObjUtil.unwrap(((ApiResult)wrappedObj).getData(), objConsumer);
            return;
        }
        if (wrappedObj instanceof PagingVO) {
            for (Object record : ((PagingVO)wrappedObj).getRecords()) {
                ObjUtil.unwrap(record, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Map) {
            for (Object value : ((Map)wrappedObj).values()) {
                ObjUtil.unwrap(value, objConsumer);
            }
            return;
        }
        if (clazz.isArray()) {
            for (Object o2 : (Object[])wrappedObj) {
                ObjUtil.unwrap(o2, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Iterable) {
            for (Object o3 : (Iterable)wrappedObj) {
                ObjUtil.unwrap(o3, objConsumer);
            }
            return;
        }
        if (wrappedObj instanceof Optional) {
            ((Optional)wrappedObj).ifPresent(o -> ObjUtil.unwrap(o, objConsumer));
            return;
        }
        if (wrappedObj instanceof CloudtOptional) {
            ((CloudtOptional)wrappedObj).ifPresent(o -> ObjUtil.unwrap(o, objConsumer));
            return;
        }
        objConsumer.accept(wrappedObj);
    }

    public static Object convertBasicValue(Object obj, @NotNull String javaType) {
        if (obj == null) {
            return null;
        }
        switch (javaType) {
            case "java.lang.String": {
                return obj.toString();
            }
            case "java.lang.Long": {
                return Long.valueOf(obj.toString());
            }
            case "java.lang.Integer": {
                return Integer.valueOf(obj.toString());
            }
            case "java.lang.Boolean": {
                return Boolean.valueOf(obj.toString());
            }
            case "java.lang.Double": {
                return Double.valueOf(obj.toString());
            }
            case "java.lang.Float": {
                return Float.valueOf(obj.toString());
            }
            case "java.lang.Short": {
                return Short.valueOf(obj.toString());
            }
            case "java.lang.Character": {
                return Character.valueOf(obj.toString().charAt(0));
            }
            case "java.lang.Byte": {
                return Byte.valueOf(obj.toString());
            }
            case "java.time.LocalDateTime": {
                return DatetimeUtil.parseLocalDateTime((String)obj.toString());
            }
            case "java.time.LocalDate": {
                return DatetimeUtil.parseLocalDate((String)obj.toString());
            }
            case "java.util.Date": {
                return DatetimeUtil.parseForDate((String)obj.toString());
            }
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a" + javaType);
    }
}

